/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.extensionmanager.gui.catalog;

import java.io.IOException;
import java.net.URI;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.ext.extensionmanager.core.ExtensionCatalogManager;
import qupath.ext.extensionmanager.core.Version;
import qupath.ext.extensionmanager.core.catalog.Extension;
import qupath.ext.extensionmanager.core.catalog.Release;
import qupath.ext.extensionmanager.core.savedentities.InstalledExtension;
import qupath.ext.extensionmanager.core.savedentities.SavedCatalog;
import qupath.ext.extensionmanager.core.tools.FileTools;
import qupath.ext.extensionmanager.gui.ProgressWindow;
import qupath.ext.extensionmanager.gui.UiUtils;
import qupath.fx.dialogs.Dialogs;

class ExtensionModificationWindow
extends Stage {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionModificationWindow.class);
    private static final ResourceBundle resources = UiUtils.getResources();
    private final ExtensionCatalogManager extensionCatalogManager;
    private final SavedCatalog savedCatalog;
    private final Extension extension;
    private final InstalledExtension installedExtension;
    private final Runnable onInvalidExtensionDirectory;
    @FXML
    private Label name;
    @FXML
    private Label currentVersion;
    @FXML
    private ChoiceBox<Release> release;
    @FXML
    private CheckBox optionalDependencies;
    @FXML
    private TextArea filesToDownload;
    @FXML
    private VBox replaceDirectory;
    @FXML
    private Label replaceDirectoryLabel;
    @FXML
    private Hyperlink replaceDirectoryLink;
    @FXML
    private Button submit;

    public ExtensionModificationWindow(ExtensionCatalogManager extensionCatalogManager, SavedCatalog savedCatalog, Extension extension, InstalledExtension installedExtension, Runnable onInvalidExtensionDirectory) throws IOException {
        this.extensionCatalogManager = extensionCatalogManager;
        this.savedCatalog = savedCatalog;
        this.extension = extension;
        this.installedExtension = installedExtension;
        this.onInvalidExtensionDirectory = onInvalidExtensionDirectory;
        UiUtils.loadFXML((Object)this, ExtensionModificationWindow.class.getResource("extension_modification_window.fxml"));
        UiUtils.promptExtensionDirectory(extensionCatalogManager.getExtensionDirectoryPath(), onInvalidExtensionDirectory);
        this.initModality(Modality.WINDOW_MODAL);
        this.setTitle(resources.getString(installedExtension == null ? "Catalog.ExtensionModificationWindow.installExtension" : "Catalog.ExtensionModificationWindow.editExtension"));
        this.name.setText(extension.name());
        if (installedExtension == null) {
            this.currentVersion.setVisible(false);
            this.currentVersion.setManaged(false);
        } else {
            this.currentVersion.setText(MessageFormat.format(resources.getString("Catalog.ExtensionModificationWindow.currentVersion"), installedExtension.releaseName()));
        }
        this.release.getItems().addAll(extension.releases().stream().filter(release -> release.versionRange().isCompatible(extensionCatalogManager.getVersion())).toList());
        this.release.setConverter((StringConverter)new StringConverter<Release>(this){

            public String toString(Release object) {
                return object == null ? null : object.name();
            }

            public Release fromString(String string) {
                return null;
            }
        });
        this.release.getSelectionModel().select(this.release.getItems().isEmpty() ? null : (Release)this.release.getItems().getFirst());
        this.optionalDependencies.visibleProperty().bind(this.release.getSelectionModel().selectedItemProperty().map(release -> !release.optionalDependencyUrls().isEmpty()));
        this.optionalDependencies.managedProperty().bind((ObservableValue)this.optionalDependencies.visibleProperty());
        this.optionalDependencies.setSelected(installedExtension != null && installedExtension.optionalDependenciesInstalled());
        this.filesToDownload.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            try {
                return extensionCatalogManager.getDownloadLinks(savedCatalog, extension, new InstalledExtension(((Release)this.release.getSelectionModel().getSelectedItem()).name(), this.optionalDependencies.isSelected())).stream().map(URI::toString).collect(Collectors.joining("\n"));
            }
            catch (IllegalArgumentException | NullPointerException | SecurityException e) {
                logger.error("Error while retrieving download links", (Throwable)e);
                return resources.getString("Catalog.ExtensionModificationWindow.cannotRetrieveLinks");
            }
        }, (Observable[])new Observable[]{this.release.getSelectionModel().selectedItemProperty(), this.optionalDependencies.selectedProperty()}));
        try {
            Path extensionDirectory = extensionCatalogManager.getExtensionDirectory(savedCatalog, extension);
            if (FileTools.isDirectoryNotEmpty(extensionDirectory)) {
                this.replaceDirectoryLabel.setText(resources.getString("Catalog.ExtensionModificationWindow.replaceDirectory"));
                this.replaceDirectoryLink.setText(extensionDirectory.toString());
            } else {
                this.replaceDirectory.setVisible(false);
                this.replaceDirectory.setManaged(false);
            }
        }
        catch (IOException | NullPointerException | SecurityException | InvalidPathException e) {
            logger.error("Cannot see if extension directory is not empty", (Throwable)e);
            this.replaceDirectoryLabel.setText(resources.getString("Catalog.ExtensionModificationWindow.extensionDirectoryNotRetrieved"));
            this.replaceDirectoryLink.setVisible(false);
            this.replaceDirectoryLink.setManaged(false);
        }
        this.submit.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> resources.getString(this.getSubmitText()), (Observable[])new Observable[]{this.release.getSelectionModel().selectedItemProperty()}));
    }

    @FXML
    private void onReplacedDirectoryClicked(ActionEvent ignored) {
        UiUtils.openFolderInFileExplorer(Paths.get(this.replaceDirectoryLink.getText(), new String[0]));
    }

    @FXML
    private void onSubmitClicked(ActionEvent ignored) {
        ProgressWindow progressWindow;
        if (this.release.getSelectionModel().isEmpty()) {
            return;
        }
        Release selectedRelease = (Release)this.release.getSelectionModel().getSelectedItem();
        UiUtils.promptExtensionDirectory(this.extensionCatalogManager.getExtensionDirectoryPath(), this.onInvalidExtensionDirectory);
        try {
            if (this.installedExtension == null && this.isJarAlreadyDownloaded(selectedRelease)) {
                boolean confirmation;
                boolean bl = confirmation = new Dialogs.Builder().alertType(Alert.AlertType.CONFIRMATION).buttons(new ButtonType[]{new ButtonType(resources.getString("Catalog.ExtensionModificationWindow.continueAnyway"), ButtonBar.ButtonData.OK_DONE), ButtonType.CANCEL}).title(resources.getString("Catalog.ExtensionModificationWindow.extensionAlreadyInstalled")).content((Node)new Label(resources.getString("Catalog.ExtensionModificationWindow.extensionAlreadyInstalledDetails"))).resizable().showAndWait().orElse(ButtonType.CANCEL).getButtonData() == ButtonBar.ButtonData.OK_DONE;
                if (!confirmation) {
                    return;
                }
            }
        }
        catch (NullPointerException | InvalidPathException e) {
            logger.debug("Cannot get file name from {}. Assuming {} with release {} is not already installed", new Object[]{selectedRelease.mainUrl(), this.extension.name(), selectedRelease.name()});
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            progressWindow = new ProgressWindow(MessageFormat.format(resources.getString(this.installedExtension == null ? "Catalog.ExtensionModificationWindow.installing" : "Catalog.ExtensionModificationWindow.updating"), this.extension.name(), selectedRelease.name()), executor::shutdownNow);
        }
        catch (IOException e) {
            logger.error("Error while creating progress window", (Throwable)e);
            executor.shutdown();
            return;
        }
        progressWindow.initOwner((Window)this);
        progressWindow.show();
        executor.execute(() -> {
            try {
                this.extensionCatalogManager.installOrUpdateExtension(this.savedCatalog, this.extension, new InstalledExtension(selectedRelease.name(), this.optionalDependencies.isSelected()), progress -> Platform.runLater(() -> progressWindow.setProgress(progress.floatValue())), (step, resource) -> Platform.runLater(() -> progressWindow.setStatus(MessageFormat.format(resources.getString(switch (step) {
                    default -> throw new MatchException(null, null);
                    case ExtensionCatalogManager.InstallationStep.DOWNLOADING -> "Catalog.ExtensionModificationWindow.downloading";
                    case ExtensionCatalogManager.InstallationStep.EXTRACTING_ZIP -> "Catalog.ExtensionModificationWindow.extracting";
                }), resource))));
                Platform.runLater(() -> {
                    progressWindow.close();
                    Dialogs.showInfoNotification((String)resources.getString("Catalog.ExtensionModificationWindow.extensionManager"), (String)MessageFormat.format(resources.getString("Catalog.ExtensionModificationWindow.installed"), this.extension.name(), ((Release)this.release.getSelectionModel().getSelectedItem()).name()));
                    this.close();
                });
            }
            catch (Exception e) {
                Platform.runLater(() -> ((ProgressWindow)progressWindow).close());
                if (e instanceof InterruptedException || e.getCause() instanceof InterruptedException) {
                    logger.debug("Installation of {} interrupted", (Object)this.extension.name(), (Object)e);
                }
                logger.error("Error while installing {}", (Object)this.extension.name(), (Object)e);
                Platform.runLater(() -> Dialogs.showErrorMessage((String)resources.getString("Catalog.ExtensionModificationWindow.installationError"), (String)MessageFormat.format(resources.getString("Catalog.ExtensionModificationWindow.notInstalled"), this.extension.name(), ((Release)this.release.getSelectionModel().getSelectedItem()).name(), e.getLocalizedMessage())));
            }
        });
        executor.shutdown();
    }

    private String getSubmitText() {
        if (this.installedExtension == null) {
            return "Catalog.ExtensionModificationWindow.install";
        }
        if (this.release.getSelectionModel().getSelectedItem() == null) {
            return "Catalog.ExtensionModificationWindow.update";
        }
        try {
            Version selectedVersion = new Version(((Release)this.release.getSelectionModel().getSelectedItem()).name());
            Version installedVersion = new Version(this.installedExtension.releaseName());
            if (selectedVersion.compareTo(installedVersion) < 0) {
                return "Catalog.ExtensionModificationWindow.downgrade";
            }
            if (selectedVersion.compareTo(installedVersion) > 0) {
                return "Catalog.ExtensionModificationWindow.update";
            }
            return "Catalog.ExtensionModificationWindow.reinstall";
        }
        catch (IllegalArgumentException e) {
            logger.debug("Cannot create version from selected item or installed release", (Throwable)e);
            return "Catalog.ExtensionModificationWindow.update";
        }
    }

    private boolean isJarAlreadyDownloaded(Release release) {
        return Stream.concat(this.extensionCatalogManager.getManuallyInstalledJars().stream(), this.extensionCatalogManager.getCatalogManagedInstalledJars().stream()).map(Path::getFileName).filter(Objects::nonNull).map(Path::toString).anyMatch(path -> path.equalsIgnoreCase(FileTools.getFileNameFromURI(release.mainUrl())));
    }
}

