/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.extensionmanager.gui.catalog;

import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.Glyph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.ext.extensionmanager.core.ExtensionCatalogManager;
import qupath.ext.extensionmanager.core.Version;
import qupath.ext.extensionmanager.core.catalog.Extension;
import qupath.ext.extensionmanager.core.catalog.Release;
import qupath.ext.extensionmanager.core.savedentities.InstalledExtension;
import qupath.ext.extensionmanager.core.savedentities.SavedCatalog;
import qupath.ext.extensionmanager.gui.ExtensionCatalogModel;
import qupath.ext.extensionmanager.gui.UiUtils;
import qupath.ext.extensionmanager.gui.catalog.ExtensionDetails;
import qupath.ext.extensionmanager.gui.catalog.ExtensionModificationWindow;
import qupath.fx.dialogs.Dialogs;

class ExtensionLine
extends HBox {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionLine.class);
    private static final ResourceBundle resources = UiUtils.getResources();
    private final ExtensionCatalogManager extensionCatalogManager;
    private final ExtensionCatalogModel model;
    private final SavedCatalog savedCatalog;
    private final Extension extension;
    private final Runnable onInvalidExtensionDirectory;
    @FXML
    private Label name;
    @FXML
    private Tooltip descriptionTooltip;
    @FXML
    private Hyperlink updateAvailable;
    @FXML
    private Tooltip updateAvailableTooltip;
    @FXML
    private Region separator;
    @FXML
    private Button add;
    @FXML
    private Button settings;
    @FXML
    private Button delete;
    @FXML
    private Button info;
    @FXML
    private Tooltip infoTooltip;

    public ExtensionLine(ExtensionCatalogManager extensionCatalogManager, ExtensionCatalogModel model, SavedCatalog savedCatalog, Extension extension, Runnable onInvalidExtensionDirectory) throws IOException {
        this.extensionCatalogManager = extensionCatalogManager;
        this.model = model;
        this.savedCatalog = savedCatalog;
        this.extension = extension;
        this.onInvalidExtensionDirectory = onInvalidExtensionDirectory;
        UiUtils.loadFXML((Object)this, ExtensionLine.class.getResource("extension_line.fxml"));
        ReadOnlyObjectProperty<Optional<InstalledExtension>> installedExtension = model.getInstalledExtension(savedCatalog, extension);
        if (((Optional)installedExtension.get()).isPresent()) {
            this.name.setText(String.format("%s %s", extension.name(), ((InstalledExtension)((Optional)installedExtension.get()).get()).releaseName()));
        } else {
            this.name.setText(extension.name());
        }
        installedExtension.addListener((p, o, n) -> {
            if (n.isPresent()) {
                this.name.setText(String.format("%s %s", extension.name(), ((InstalledExtension)n.get()).releaseName()));
            } else {
                this.name.setText(extension.name());
            }
        });
        Glyph star = UiUtils.getFontAwesomeIcon(FontAwesome.Glyph.STAR);
        star.getStyleClass().add((Object)(extension.starred() ? UiUtils.getClassName(UiUtils.CssClass.STAR) : UiUtils.getClassName(UiUtils.CssClass.INVISIBLE)));
        this.name.setContentDisplay(ContentDisplay.LEFT);
        this.name.setGraphic((Node)star);
        StringBuilder descriptionText = new StringBuilder(extension.description());
        if (extension.starred()) {
            descriptionText.append("\n");
            descriptionText.append(resources.getString("Catalog.ExtensionLine.starredExtension"));
        }
        if (this.noAvailableRelease()) {
            descriptionText.append("\n");
            descriptionText.append(resources.getString("Catalog.ExtensionLine.extensionNotCompatible"));
        }
        this.descriptionTooltip.setText(descriptionText.toString());
        Tooltip.install((Node)this.separator, (Tooltip)this.descriptionTooltip);
        this.updateAvailable.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (((Optional)installedExtension.get()).isEmpty()) {
                return false;
            }
            Version installedVersion = new Version(((InstalledExtension)((Optional)installedExtension.get()).get()).releaseName());
            Optional<String> availableVersion = extension.releases().stream().filter(release -> release.versionRange().isCompatible(extensionCatalogManager.getVersion())).map(Release::name).filter(named -> new Version((String)named).compareTo(installedVersion) > 0).findAny();
            availableVersion.ifPresent(version -> this.updateAvailableTooltip.setText(MessageFormat.format(resources.getString("Catalog.ExtensionLine.updateAvailableDetails"), version)));
            return availableVersion.isPresent();
        }, (Observable[])new Observable[]{installedExtension}));
        this.updateAvailable.managedProperty().bind((ObservableValue)this.updateAvailable.visibleProperty());
        this.add.setGraphic((Node)UiUtils.getFontAwesomeIcon(FontAwesome.Glyph.PLUS_CIRCLE));
        this.settings.setGraphic((Node)UiUtils.getFontAwesomeIcon(FontAwesome.Glyph.GEAR));
        this.delete.setGraphic((Node)UiUtils.getFontAwesomeIcon(FontAwesome.Glyph.MINUS_CIRCLE));
        this.info.setGraphic((Node)UiUtils.getFontAwesomeIcon(FontAwesome.Glyph.INFO_CIRCLE));
        this.add.getGraphic().getStyleClass().add((Object)"add-button");
        this.settings.getGraphic().getStyleClass().add((Object)"other-buttons");
        this.delete.getGraphic().getStyleClass().add((Object)"delete-button");
        this.info.getGraphic().getStyleClass().add((Object)"other-buttons");
        this.add.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> ((Optional)installedExtension.get()).isEmpty(), (Observable[])new Observable[]{installedExtension}));
        this.settings.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> ((Optional)installedExtension.get()).isPresent(), (Observable[])new Observable[]{installedExtension}));
        this.delete.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> ((Optional)installedExtension.get()).isPresent(), (Observable[])new Observable[]{installedExtension}));
        this.add.managedProperty().bind((ObservableValue)this.add.visibleProperty());
        this.settings.managedProperty().bind((ObservableValue)this.settings.visibleProperty());
        this.delete.managedProperty().bind((ObservableValue)this.delete.visibleProperty());
        this.add.setDisable(this.noAvailableRelease());
        this.infoTooltip.setText(String.format("%s\n%s", extension.description(), extension.homepage()));
    }

    @FXML
    private void onUpdateAvailableClicked(ActionEvent ignored) {
        this.onSettingsClicked(ignored);
    }

    @FXML
    private void onAddClicked(ActionEvent ignored) {
        try {
            ExtensionModificationWindow extensionModificationWindow = new ExtensionModificationWindow(this.extensionCatalogManager, this.savedCatalog, this.extension, ((Optional)this.model.getInstalledExtension(this.savedCatalog, this.extension).get()).orElse(null), this.onInvalidExtensionDirectory);
            extensionModificationWindow.initOwner(this.getScene().getWindow());
            extensionModificationWindow.show();
        }
        catch (IOException e) {
            logger.error("Error when creating extension modification window", (Throwable)e);
        }
    }

    @FXML
    private void onSettingsClicked(ActionEvent ignored) {
        try {
            ExtensionModificationWindow extensionModificationWindow = new ExtensionModificationWindow(this.extensionCatalogManager, this.savedCatalog, this.extension, ((Optional)this.model.getInstalledExtension(this.savedCatalog, this.extension).get()).orElse(null), this.onInvalidExtensionDirectory);
            extensionModificationWindow.initOwner(this.getScene().getWindow());
            extensionModificationWindow.show();
        }
        catch (IOException e) {
            logger.error("Error when creating extension modification window", (Throwable)e);
        }
    }

    @FXML
    private void onDeleteClicked(ActionEvent ignored) {
        Path directoryToDelete;
        try {
            directoryToDelete = this.extensionCatalogManager.getExtensionDirectory(this.savedCatalog, this.extension);
        }
        catch (IOException | NullPointerException | SecurityException | InvalidPathException e) {
            logger.error("Cannot retrieve directory containing the files of the extension to delete", (Throwable)e);
            Dialogs.showErrorMessage((String)resources.getString("Catalog.ExtensionLine.error"), (String)MessageFormat.format(resources.getString("Catalog.ExtensionLine.cannotDeleteExtension"), e.getLocalizedMessage()));
            return;
        }
        boolean confirmation = Dialogs.showConfirmDialog((String)resources.getString("Catalog.ExtensionLine.removeExtension"), (String)MessageFormat.format(resources.getString("Catalog.ExtensionLine.remove"), this.extension.name(), directoryToDelete));
        if (!confirmation) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                this.extensionCatalogManager.removeExtension(this.savedCatalog, this.extension);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).handle((v, error) -> {
            if (error == null) {
                Dialogs.showInfoNotification((String)resources.getString("Catalog.ExtensionLine.extensionManager"), (String)MessageFormat.format(resources.getString("Catalog.ExtensionLine.removed"), this.extension.name()));
            } else {
                logger.error("Error while deleting extension", error);
                Dialogs.showErrorMessage((String)resources.getString("Catalog.ExtensionLine.error"), (String)MessageFormat.format(resources.getString("Catalog.ExtensionLine.cannotDeleteExtension"), error.getLocalizedMessage()));
            }
            return null;
        });
    }

    @FXML
    private void onInfoClicked(ActionEvent ignored) {
        try {
            ExtensionDetails extensionDetails = new ExtensionDetails(this.extension, this.noAvailableRelease());
            extensionDetails.initOwner(this.getScene().getWindow());
            extensionDetails.show();
        }
        catch (IOException e) {
            logger.error("Error when creating extension detail pane", (Throwable)e);
        }
    }

    private boolean noAvailableRelease() {
        return this.extension.releases().stream().noneMatch(release -> release.versionRange().isCompatible(this.extensionCatalogManager.getVersion()));
    }
}

