/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.extensionmanager.gui.catalog;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.stage.Modality;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.ext.extensionmanager.core.catalog.Extension;
import qupath.ext.extensionmanager.gui.UiUtils;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.utils.FXUtils;

class ExtensionDetails
extends Stage {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionDetails.class);
    private static final ResourceBundle resources = UiUtils.getResources();
    @FXML
    private Label description;
    @FXML
    private Hyperlink homepage;
    @FXML
    private Label notCompatible;

    public ExtensionDetails(Extension extension, boolean noAvailableRelease) throws IOException {
        UiUtils.loadFXML((Object)this, ExtensionDetails.class.getResource("extension_details.fxml"));
        FXUtils.addCloseWindowShortcuts((Stage)this);
        this.initModality(Modality.WINDOW_MODAL);
        this.setTitle(extension.name());
        this.description.setText(extension.description());
        this.homepage.setText(extension.homepage().toString());
        this.notCompatible.setVisible(noAvailableRelease);
        this.notCompatible.setManaged(this.notCompatible.isVisible());
    }

    @FXML
    private void onHomepageClicked(ActionEvent ignored) {
        String link = this.homepage.getText();
        UiUtils.openLinkInWebBrowser(link).exceptionally(error -> {
            logger.error("Error when opening {} in browser", (Object)link, error);
            Dialogs.showErrorMessage((String)resources.getString("Catalog.ExtensionDetails.browserError"), (String)MessageFormat.format(resources.getString("Catalog.ExtensionDetails.cannotOpen"), link, error.getLocalizedMessage()));
            return null;
        });
    }

    @FXML
    private void onCloseClicked(ActionEvent ignored) {
        this.close();
    }
}

