/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.extensionmanager.gui.catalog;

import java.io.IOException;
import java.util.Objects;
import java.util.stream.IntStream;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.VBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.ext.extensionmanager.core.ExtensionCatalogManager;
import qupath.ext.extensionmanager.core.catalog.CatalogFetcher;
import qupath.ext.extensionmanager.core.savedentities.SavedCatalog;
import qupath.ext.extensionmanager.gui.ExtensionCatalogModel;
import qupath.ext.extensionmanager.gui.UiUtils;
import qupath.ext.extensionmanager.gui.catalog.ExtensionLine;

public class CatalogPane
extends TitledPane {
    private static final Logger logger = LoggerFactory.getLogger(CatalogPane.class);
    @FXML
    private VBox extensions;

    public CatalogPane(ExtensionCatalogManager extensionCatalogManager, SavedCatalog savedCatalog, ExtensionCatalogModel model, Runnable onInvalidExtensionDirectory) throws IOException {
        UiUtils.loadFXML((Object)this, CatalogPane.class.getResource("catalog_pane.fxml"));
        this.setText(savedCatalog.name());
        CatalogFetcher.getCatalog(savedCatalog.rawUri()).handle((fetchedCatalog, error) -> {
            if (error == null) {
                Platform.runLater(() -> {
                    this.setExpanded(true);
                    this.extensions.getChildren().addAll(IntStream.range(0, fetchedCatalog.extensions().size()).mapToObj(i -> {
                        try {
                            ExtensionLine extensionLine = new ExtensionLine(extensionCatalogManager, model, savedCatalog, fetchedCatalog.extensions().get(i), onInvalidExtensionDirectory);
                            if (i % 2 == 0) {
                                extensionLine.getStyleClass().add((Object)UiUtils.getClassName(UiUtils.CssClass.ODD_ROW));
                            }
                            return extensionLine;
                        }
                        catch (IOException e) {
                            logger.error("Error while creating extension line", (Throwable)e);
                            return null;
                        }
                    }).filter(Objects::nonNull).toList());
                });
            } else {
                logger.warn("Error when fetching catalog at {}", (Object)savedCatalog.rawUri(), error);
            }
            return null;
        });
    }
}

