/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.extensionmanager.gui;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXMLLoader;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.Glyph;
import org.controlsfx.glyphfont.GlyphFont;
import org.controlsfx.glyphfont.GlyphFontRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UiUtils {
    private static final Logger logger = LoggerFactory.getLogger(UiUtils.class);
    private static final ResourceBundle resources = ResourceBundle.getBundle("qupath.ext.extensionmanager.strings");
    private static final GlyphFont fontAwesome = GlyphFontRegistry.font((String)"FontAwesome");

    private UiUtils() {
        throw new AssertionError((Object)"This class is not instantiable.");
    }

    public static void loadFXML(Object controller, URL url) throws IOException {
        FXMLLoader loader = new FXMLLoader(url, resources);
        loader.setRoot(controller);
        loader.setController(controller);
        loader.load();
    }

    public static ResourceBundle getResources() {
        return resources;
    }

    public static String getClassName(CssClass cssClass) {
        return cssClass.className;
    }

    public static CompletableFuture<Void> openLinkInWebBrowser(String url) {
        return CompletableFuture.runAsync(() -> {
            Desktop desktop;
            Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
            if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                try {
                    desktop.browse(new URI(url));
                }
                catch (IOException | URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static CompletableFuture<Void> openFolderInFileExplorer(Path directory) {
        return CompletableFuture.runAsync(() -> {
            Desktop desktop;
            Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
            if (desktop != null && desktop.isSupported(Desktop.Action.OPEN)) {
                try {
                    desktop.open(directory.toFile());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public static void promptExtensionDirectory(ReadOnlyObjectProperty<Path> extensionDirectoryProperty, Runnable onInvalidExtensionDirectory) {
        Path extensionDirectory = (Path)extensionDirectoryProperty.get();
        try {
            if (extensionDirectory == null || !Files.isDirectory(extensionDirectory, new LinkOption[0])) {
                onInvalidExtensionDirectory.run();
            }
        }
        catch (SecurityException e) {
            logger.debug("Cannot check if {} is invalid", (Object)extensionDirectory, (Object)e);
        }
    }

    public static Glyph getFontAwesomeIcon(FontAwesome.Glyph glyph) {
        return fontAwesome.create((Enum)glyph);
    }

    public static <T> void bindListInUIThread(ObservableList<T> listToUpdate, ObservableList<T> listToListen) {
        listToUpdate.addAll(listToListen);
        listToListen.addListener(change -> Platform.runLater(() -> {
            if (Platform.isFxApplicationThread()) {
                while (change.next()) {
                    if (change.wasAdded()) {
                        listToUpdate.addAll((Collection)change.getAddedSubList());
                        continue;
                    }
                    listToUpdate.removeAll((Collection)change.getRemoved());
                }
                change.reset();
            } else {
                Platform.runLater(() -> {
                    while (change.next()) {
                        if (change.wasAdded()) {
                            listToUpdate.addAll((Collection)change.getAddedSubList());
                            continue;
                        }
                        listToUpdate.removeAll((Collection)change.getRemoved());
                    }
                    change.reset();
                });
            }
        }));
    }

    public static <T> void bindPropertyInUIThread(WritableValue<T> propertyToUpdate, ObservableValue<T> propertyToListen) {
        propertyToUpdate.setValue(propertyToListen.getValue());
        propertyToListen.addListener((p, o, n) -> {
            if (Platform.isFxApplicationThread()) {
                propertyToUpdate.setValue(n);
            } else {
                Platform.runLater(() -> propertyToUpdate.setValue(n));
            }
        });
    }

    public static enum CssClass {
        ODD_ROW("odd-row"),
        STAR("star"),
        INVISIBLE("invisible");

        private final String className;

        private CssClass(String className) {
            this.className = className;
        }
    }
}

