/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.extensionmanager.gui;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.ext.extensionmanager.gui.UiUtils;
import qupath.fx.dialogs.Dialogs;

class ManuallyInstalledExtensionLine
extends HBox {
    private static final Logger logger = LoggerFactory.getLogger(ManuallyInstalledExtensionLine.class);
    private static final ResourceBundle resources = UiUtils.getResources();
    private final Path jarPath;
    @FXML
    private Label name;
    @FXML
    private Button delete;

    public ManuallyInstalledExtensionLine(Path jarPath) throws IOException {
        this.jarPath = jarPath;
        UiUtils.loadFXML((Object)this, ManuallyInstalledExtensionLine.class.getResource("manually_installed_extension_line.fxml"));
        if (jarPath.getFileName() != null) {
            this.name.setText(jarPath.getFileName().toString());
        }
        this.delete.setGraphic((Node)UiUtils.getFontAwesomeIcon(FontAwesome.Glyph.MINUS_CIRCLE));
        this.delete.getGraphic().getStyleClass().add((Object)"delete-button");
    }

    @FXML
    private void onDeleteClicked(ActionEvent ignored) {
        boolean confirmation = Dialogs.showConfirmDialog((String)resources.getString("ManuallyInstalledExtensionLine.deleteExtension"), (String)MessageFormat.format(resources.getString("ManuallyInstalledExtensionLine.remove"), this.jarPath.getFileName()));
        if (!confirmation) {
            return;
        }
        try {
            Files.delete(this.jarPath);
            Dialogs.showInfoNotification((String)resources.getString("ManuallyInstalledExtensionLine.extensionManager"), (String)MessageFormat.format(resources.getString("ManuallyInstalledExtensionLine.extensionRemoved"), this.jarPath.getFileName()));
        }
        catch (IOException | SecurityException e) {
            logger.error("Cannot delete extension located at {}", (Object)this.jarPath, (Object)e);
            Dialogs.showErrorMessage((String)resources.getString("ManuallyInstalledExtensionLine.deleteExtension"), (String)MessageFormat.format(resources.getString("ManuallyInstalledExtensionLine.cannotDeleteExtension"), e.getLocalizedMessage()));
        }
    }
}

