/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.extensionmanager.gui;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.ext.extensionmanager.core.ExtensionCatalogManager;
import qupath.ext.extensionmanager.core.savedentities.SavedCatalog;
import qupath.ext.extensionmanager.gui.CatalogManager;
import qupath.ext.extensionmanager.gui.ExtensionCatalogModel;
import qupath.ext.extensionmanager.gui.ManuallyInstalledExtensionLine;
import qupath.ext.extensionmanager.gui.UiUtils;
import qupath.ext.extensionmanager.gui.catalog.CatalogPane;
import qupath.fx.dialogs.Dialogs;

public class ExtensionManager
extends Stage {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionManager.class);
    private static final ResourceBundle resources = UiUtils.getResources();
    private final ExtensionCatalogManager extensionCatalogManager;
    private final ExtensionCatalogModel model;
    private final Runnable onInvalidExtensionDirectory;
    private CatalogManager catalogManager;
    @FXML
    private VBox catalogs;
    @FXML
    private TitledPane manuallyInstalledExtensionsPane;
    @FXML
    private VBox manuallyInstalledExtensions;
    @FXML
    private Label noCatalogOrExtension;

    public ExtensionManager(ExtensionCatalogManager extensionCatalogManager, Runnable onInvalidExtensionDirectory) throws IOException {
        this.extensionCatalogManager = extensionCatalogManager;
        this.model = new ExtensionCatalogModel(extensionCatalogManager);
        this.onInvalidExtensionDirectory = onInvalidExtensionDirectory;
        UiUtils.loadFXML((Object)this, ExtensionManager.class.getResource("extension_manager.fxml"));
        UiUtils.promptExtensionDirectory(extensionCatalogManager.getExtensionDirectoryPath(), onInvalidExtensionDirectory);
        this.setCatalogs();
        this.model.getCatalogs().addListener(change -> this.setCatalogs());
        this.manuallyInstalledExtensionsPane.visibleProperty().bind((ObservableValue)Bindings.isNotEmpty((ObservableList)this.manuallyInstalledExtensions.getChildren()));
        this.manuallyInstalledExtensionsPane.managedProperty().bind((ObservableValue)this.manuallyInstalledExtensionsPane.visibleProperty());
        this.setManuallyInstalledExtensions();
        this.model.getManuallyInstalledJars().addListener(change -> this.setManuallyInstalledExtensions());
        this.noCatalogOrExtension.visibleProperty().bind((ObservableValue)this.manuallyInstalledExtensionsPane.visibleProperty().not().and((ObservableBooleanValue)Bindings.isEmpty((ObservableList)this.catalogs.getChildren())));
        this.noCatalogOrExtension.managedProperty().bind((ObservableValue)this.noCatalogOrExtension.visibleProperty());
    }

    public static void promptToCopyFilesToExtensionDirectory(List<File> filesToCopy, ReadOnlyObjectProperty<Path> extensionDirectoryPath, Runnable onInvalidExtensionDirectory) {
        boolean confirmation;
        UiUtils.promptExtensionDirectory(extensionDirectoryPath, onInvalidExtensionDirectory);
        Path extensionFolder = (Path)extensionDirectoryPath.get();
        if (extensionFolder == null) {
            Dialogs.showErrorMessage((String)resources.getString("ExtensionManager.error"), (String)resources.getString("ExtensionManager.cannotCopyFiles"));
            return;
        }
        HashMap<File, File> sourceToDestinationFiles = new HashMap<File, File>();
        for (File file2 : filesToCopy) {
            try {
                sourceToDestinationFiles.put(file2, extensionFolder.resolve(file2.toPath().getFileName()).toFile());
            }
            catch (NullPointerException | InvalidPathException e) {
                logger.debug("Error while resolving path of {} in extension folder {}", new Object[]{file2, extensionFolder, e});
            }
        }
        List<File> destinationFilesAlreadyExisting = sourceToDestinationFiles.values().stream().filter(file -> {
            try {
                return file.exists();
            }
            catch (SecurityException e) {
                logger.debug("Cannot check if {} exists", file, (Object)e);
                return false;
            }
        }).toList();
        if (!destinationFilesAlreadyExisting.isEmpty() && !(confirmation = Dialogs.showConfirmDialog((String)resources.getString("ExtensionManager.copyFiles"), (String)MessageFormat.format(resources.getString("ExtensionManager.alreadyExist"), destinationFilesAlreadyExisting.size() == 1 ? destinationFilesAlreadyExisting.getFirst() : destinationFilesAlreadyExisting)))) {
            return;
        }
        ArrayList<Exception> errors = new ArrayList<Exception>();
        for (Map.Entry entry : sourceToDestinationFiles.entrySet()) {
            try {
                Files.copy(((File)entry.getKey()).toPath(), ((File)entry.getValue()).toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException | SecurityException | InvalidPathException e) {
                logger.error("Cannot copy {} to {}", new Object[]{entry.getKey(), entry.getValue(), e});
                errors.add(e);
            }
        }
        if (!errors.isEmpty()) {
            Dialogs.showErrorMessage((String)resources.getString("ExtensionManager.copyError"), (String)MessageFormat.format(resources.getString("ExtensionManager.errorWhileCopying"), errors.stream().map(Throwable::getLocalizedMessage).collect(Collectors.joining("\n"))));
        }
    }

    @FXML
    private void onOpenExtensionDirectory(ActionEvent ignored) {
        UiUtils.promptExtensionDirectory(this.extensionCatalogManager.getExtensionDirectoryPath(), this.onInvalidExtensionDirectory);
        Path extensionDirectory = (Path)this.extensionCatalogManager.getExtensionDirectoryPath().get();
        if (extensionDirectory == null) {
            Dialogs.showErrorMessage((String)resources.getString("ExtensionManager.error"), (String)resources.getString("ExtensionManager.cannotOpenExtensionDirectory"));
            return;
        }
        UiUtils.openFolderInFileExplorer(extensionDirectory).exceptionally(error -> {
            logger.error("Error while opening extension directory {}", (Object)extensionDirectory, error);
            Dialogs.showErrorMessage((String)resources.getString("ExtensionManager.error"), (String)MessageFormat.format(resources.getString("ExtensionManager.cannotOpen"), extensionDirectory, error.getLocalizedMessage()));
            return null;
        });
    }

    @FXML
    private void onManageCatalogsClicked(ActionEvent ignored) {
        UiUtils.promptExtensionDirectory(this.extensionCatalogManager.getExtensionDirectoryPath(), this.onInvalidExtensionDirectory);
        if (this.catalogManager == null) {
            try {
                this.catalogManager = new CatalogManager(this.extensionCatalogManager, this.model, this.onInvalidExtensionDirectory);
                this.catalogManager.initOwner((Window)this);
                this.catalogManager.show();
            }
            catch (IOException e) {
                logger.error("Error while creating catalog manager window", (Throwable)e);
            }
        }
        if (this.catalogManager != null) {
            this.catalogManager.show();
            this.catalogManager.requestFocus();
        }
    }

    private void setCatalogs() {
        this.catalogs.getChildren().setAll(this.model.getCatalogs().stream().map(catalog -> {
            try {
                return new CatalogPane(this.extensionCatalogManager, (SavedCatalog)catalog, this.model, this.onInvalidExtensionDirectory);
            }
            catch (IOException e) {
                logger.error("Error while creating catalog pane", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).toList());
    }

    private void setManuallyInstalledExtensions() {
        this.manuallyInstalledExtensions.getChildren().setAll(IntStream.range(0, this.model.getManuallyInstalledJars().size()).mapToObj(i -> {
            try {
                ManuallyInstalledExtensionLine manuallyInstalledExtensionLine = new ManuallyInstalledExtensionLine((Path)this.model.getManuallyInstalledJars().get(i));
                if (i % 2 == 0) {
                    manuallyInstalledExtensionLine.getStyleClass().add((Object)UiUtils.getClassName(UiUtils.CssClass.ODD_ROW));
                }
                return manuallyInstalledExtensionLine;
            }
            catch (IOException e) {
                logger.error("Error while manually installed extensionLine", (Throwable)e);
                return null;
            }
        }).filter(Objects::nonNull).toList());
    }
}

