/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.extensionmanager.gui;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import qupath.ext.extensionmanager.core.ExtensionCatalogManager;
import qupath.ext.extensionmanager.core.catalog.Extension;
import qupath.ext.extensionmanager.core.savedentities.InstalledExtension;
import qupath.ext.extensionmanager.core.savedentities.SavedCatalog;
import qupath.ext.extensionmanager.gui.UiUtils;

public class ExtensionCatalogModel {
    private final ObservableList<SavedCatalog> savedIndices = FXCollections.observableArrayList();
    private final ObservableList<SavedCatalog> catalogsImmutable = FXCollections.unmodifiableObservableList(this.savedIndices);
    private static final Map<CatalogExtension, ObjectProperty<Optional<InstalledExtension>>> installedExtensions = new HashMap<CatalogExtension, ObjectProperty<Optional<InstalledExtension>>>();
    private final ObservableList<Path> manuallyInstalledJars = FXCollections.observableArrayList();
    private final ObservableList<Path> manuallyInstalledJarsImmutable = FXCollections.unmodifiableObservableList(this.manuallyInstalledJars);
    private final ExtensionCatalogManager extensionCatalogManager;

    public ExtensionCatalogModel(ExtensionCatalogManager extensionCatalogManager) {
        this.extensionCatalogManager = extensionCatalogManager;
        UiUtils.bindListInUIThread(this.savedIndices, extensionCatalogManager.getCatalogs());
        UiUtils.bindListInUIThread(this.manuallyInstalledJars, extensionCatalogManager.getManuallyInstalledJars());
    }

    public ObservableList<SavedCatalog> getCatalogs() {
        return this.catalogsImmutable;
    }

    public ReadOnlyObjectProperty<Optional<InstalledExtension>> getInstalledExtension(SavedCatalog savedCatalog, Extension extension) {
        return (ReadOnlyObjectProperty)installedExtensions.computeIfAbsent(new CatalogExtension(savedCatalog, extension), e -> {
            SimpleObjectProperty installedExtension = new SimpleObjectProperty(Optional.empty());
            UiUtils.bindPropertyInUIThread(installedExtension, this.extensionCatalogManager.getInstalledExtension(e.savedCatalog, e.extension));
            return installedExtension;
        });
    }

    public ObservableList<Path> getManuallyInstalledJars() {
        return this.manuallyInstalledJarsImmutable;
    }

    private record CatalogExtension(SavedCatalog savedCatalog, Extension extension) {
    }
}

