/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.extensionmanager.core.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipExtractor {
    private static final Logger logger = LoggerFactory.getLogger(ZipExtractor.class);
    private static final int BUFFER_SIZE = 1024;

    private ZipExtractor() {
        throw new AssertionError((Object)"This class is not instantiable.");
    }

    public static void extractZipToFolder(Path inputZipPath, Path outputFolderPath, Consumer<Float> onProgress) throws IOException, InterruptedException {
        File outputFolder = outputFolderPath.toFile();
        byte[] buffer = new byte[1024];
        int numberOfZipFiles = ZipExtractor.getNumberOfFilesInZip(inputZipPath);
        logger.debug("Starting extracting {} files from {} to {}", new Object[]{numberOfZipFiles, inputZipPath, outputFolderPath});
        try (InputStream inputStream = Files.newInputStream(inputZipPath, new OpenOption[0]);
             ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry zipEntry;
            int i = 0;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                File newFile = ZipExtractor.createFile(outputFolder, zipEntry);
                if (zipEntry.isDirectory()) {
                    if (!newFile.isDirectory() && !newFile.mkdirs()) {
                        throw new IOException("Failed to create directory " + String.valueOf(newFile));
                    }
                } else {
                    File parent = newFile.getParentFile();
                    if (parent == null || !parent.isDirectory() && !parent.mkdirs()) {
                        throw new IOException("Failed to create directory " + String.valueOf(parent));
                    }
                    try (OutputStream outputStream = Files.newOutputStream(newFile.toPath(), new OpenOption[0]);){
                        int len;
                        while ((len = zipInputStream.read(buffer)) > 0) {
                            outputStream.write(buffer, 0, len);
                            if (!Thread.interrupted()) continue;
                            throw new InterruptedException(String.format("Extraction of %s interrupted", inputZipPath));
                        }
                    }
                    logger.debug("File {} extracted to {}", (Object)zipEntry, (Object)newFile);
                }
                onProgress.accept(Float.valueOf((float)i / (float)numberOfZipFiles));
                ++i;
            }
        }
    }

    private static int getNumberOfFilesInZip(Path zipPath) throws IOException {
        try (ZipFile zipFile = new ZipFile(zipPath.toFile());){
            int n = zipFile.size();
            return n;
        }
    }

    private static File createFile(File destinationDirectory, ZipEntry zipEntry) throws IOException {
        File destFile = new File(destinationDirectory, zipEntry.getName());
        String destinationDirPath = destinationDirectory.getCanonicalPath();
        String destinationFilePath = destFile.getCanonicalPath();
        if (!destinationFilePath.startsWith(destinationDirPath + File.separator)) {
            throw new IOException(String.format("The ZIP entry %s is outside of the target directory %s", zipEntry.getName(), destinationDirectory));
        }
        return destFile;
    }
}

