/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.extensionmanager.core.tools;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.ext.extensionmanager.core.tools.RecursiveDirectoryWatcher;

public class FilesWatcher
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(FilesWatcher.class);
    private static final int MAX_SEARCH_DEPTH = 8;
    private final ObservableList<Path> files = FXCollections.observableList(new CopyOnWriteArrayList());
    private final ObservableList<Path> filesImmutable = FXCollections.unmodifiableObservableList(this.files);
    private final ObservableValue<Path> directoryToWatch;
    private final Predicate<Path> filesToFind;
    private final Predicate<Path> directoriesToSkip;
    private RecursiveDirectoryWatcher directoryWatcher;

    public FilesWatcher(ObservableValue<Path> directoryToWatch, Predicate<Path> filesToFind, Predicate<Path> directoriesToSkip) {
        if (filesToFind == null) {
            throw new NullPointerException("The files to find predicate is null");
        }
        if (directoriesToSkip == null) {
            throw new NullPointerException("The directories to skip predicate is null");
        }
        this.directoryToWatch = directoryToWatch;
        this.filesToFind = filesToFind;
        this.directoriesToSkip = directoriesToSkip;
        this.setDirectoryWatcher();
        directoryToWatch.addListener((p, o, n) -> this.setDirectoryWatcher());
    }

    @Override
    public void close() throws Exception {
        if (this.directoryWatcher != null) {
            this.directoryWatcher.close();
        }
    }

    public ObservableList<Path> getFiles() {
        return this.filesImmutable;
    }

    private synchronized void setDirectoryWatcher() {
        Path directory = (Path)this.directoryToWatch.getValue();
        logger.debug("Clearing file list and resetting directory watcher to watch {}", (Object)directory);
        this.files.clear();
        if (this.directoryWatcher != null) {
            try {
                this.directoryWatcher.close();
            }
            catch (Exception e) {
                logger.debug("Error when closing directory watcher", (Throwable)e);
            }
        }
        if (directory == null) {
            logger.debug("The directory to watch is null. No file will be detected");
            return;
        }
        try {
            this.directoryWatcher = new RecursiveDirectoryWatcher(directory, 8, this.filesToFind, this.directoriesToSkip, addedFile -> {
                logger.debug("File {} added", addedFile);
                this.files.add(addedFile);
            }, removedFile -> {
                logger.debug("File {} removed", removedFile);
                this.files.remove(removedFile);
            });
        }
        catch (IOException | SecurityException | UnsupportedOperationException e) {
            logger.debug("Error when creating files watcher for {}. Files added to this directory won't be detected.", (Object)directory, (Object)e);
        }
    }
}

