/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.extensionmanager.core.tools;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTools {
    private static final Logger logger = LoggerFactory.getLogger(FileTools.class);

    private FileTools() {
        throw new AssertionError((Object)"This class is not instantiable.");
    }

    public static boolean isDirectoryNotEmpty(Path path) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (Stream<Path> entries = Files.list(path);){
                if (entries.findAny().isPresent()) {
                    logger.debug("The specified path {} is a non-empty directory", (Object)path);
                    boolean bl = true;
                    return bl;
                }
                logger.debug("The specified path {} is an empty directory", (Object)path);
                boolean bl = false;
                return bl;
            }
        }
        logger.debug("The specified path {} is not an existing directory", (Object)path);
        return false;
    }

    public static void moveDirectoryToTrashOrDeleteRecursively(File directoryToDelete) throws IOException {
        Desktop desktop;
        if (!directoryToDelete.exists()) {
            logger.debug("Can't delete {}: the path does not exist", (Object)directoryToDelete);
            return;
        }
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.MOVE_TO_TRASH)) {
            logger.debug("Moving {} to trash", (Object)directoryToDelete);
            desktop.moveToTrash(directoryToDelete);
        } else {
            logger.debug("Moving to trash not supported. Deleting {}", (Object)directoryToDelete);
            FileTools.deleteDirectoryRecursively(directoryToDelete);
        }
    }

    public static String stripInvalidFilenameCharacters(String name) {
        return name.replaceAll("[\\\\/:\"*?<>|\\n\\r]+", "");
    }

    public static String getFileNameFromURI(URI uri) {
        return Paths.get(uri.getPath(), new String[0]).getFileName().toString();
    }

    public static boolean isFileParentOfAnotherFile(File possibleParent, File possibleChild) {
        for (File parent = possibleChild.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (!parent.equals(possibleParent)) continue;
            return true;
        }
        return false;
    }

    private static void deleteDirectoryRecursively(File directoryToBeDeleted) throws IOException {
        logger.debug("Deleting children of {}", (Object)directoryToBeDeleted);
        File[] childFiles = directoryToBeDeleted.listFiles();
        if (childFiles != null) {
            for (File file : childFiles) {
                FileTools.deleteDirectoryRecursively(file);
            }
        }
        logger.debug("Deleting {}", (Object)directoryToBeDeleted);
        Files.deleteIfExists(directoryToBeDeleted.toPath());
    }
}

