/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.extensionmanager.core.catalog;

import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.ext.extensionmanager.core.Version;
import qupath.ext.extensionmanager.core.catalog.Utils;

public record VersionRange(String min, String max, List<String> excludes) {
    private static final Logger logger = LoggerFactory.getLogger(VersionRange.class);

    public VersionRange(String min, String max, List<String> excludes) {
        this.min = min;
        this.max = max;
        this.excludes = excludes == null ? List.of() : Collections.unmodifiableList(excludes);
        this.checkValidity();
    }

    public boolean isCompatible(String version) {
        Version versionObject = new Version(version);
        if (new Version(this.min).compareTo(versionObject) > 0) {
            logger.debug("This version range {} is not compatible with {} because of the minimum compatible version", (Object)this, (Object)version);
            return false;
        }
        if (this.max != null && versionObject.compareTo(new Version(this.max)) > 0) {
            logger.debug("This version range {} is not compatible with {} because of the maximum compatible version", (Object)this, (Object)version);
            return false;
        }
        if (this.excludes != null) {
            if (this.excludes.stream().map(Version::new).anyMatch(versionObject::equals)) {
                logger.debug("This version range {} is not compatible with {} because of the excluded versions", (Object)this, (Object)version);
                return false;
            }
        }
        return true;
    }

    private void checkValidity() {
        Utils.checkField(this.min, "min", "VersionRange");
        Version.isValid(this.min, false);
        if (this.max != null && new Version(this.min).compareTo(new Version(this.max)) > 0) {
            throw new IllegalArgumentException(String.format("The min version '%s' must be lower than or equal to the max version '%s'", this.min, this.max));
        }
        if (this.excludes != null) {
            for (String version : this.excludes) {
                if (new Version(this.min).compareTo(new Version(version)) <= 0) continue;
                throw new IllegalArgumentException(String.format("The min version '%s' must be lower than or equal to the excluded version '%s'", this.min, version));
            }
        }
        if (this.max != null && this.excludes != null) {
            for (String version : this.excludes) {
                if (new Version(version).compareTo(new Version(this.max)) <= 0) continue;
                throw new IllegalArgumentException(String.format("The excluded version '%s' must be lower than or equal to the max version '%s'", version, this.max));
            }
        }
    }
}

