/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.extensionmanager.core.catalog;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import qupath.ext.extensionmanager.core.Version;
import qupath.ext.extensionmanager.core.catalog.Utils;
import qupath.ext.extensionmanager.core.catalog.VersionRange;

public record Release(String name, URI mainUrl, List<URI> requiredDependencyUrls, List<URI> optionalDependencyUrls, List<URI> javadocUrls, VersionRange versionRange) {
    private static final List<String> VALID_HOSTS = List.of("github.com", "maven.scijava.org", "repo1.maven.org");
    private static final String VALID_SCHEME = "https";

    public Release(String name, URI mainUrl, List<URI> requiredDependencyUrls, List<URI> optionalDependencyUrls, List<URI> javadocUrls, VersionRange versionRange) {
        this.name = name;
        this.mainUrl = mainUrl;
        this.requiredDependencyUrls = requiredDependencyUrls == null ? List.of() : Collections.unmodifiableList(requiredDependencyUrls);
        this.optionalDependencyUrls = optionalDependencyUrls == null ? List.of() : Collections.unmodifiableList(optionalDependencyUrls);
        this.javadocUrls = javadocUrls == null ? List.of() : Collections.unmodifiableList(javadocUrls);
        this.versionRange = versionRange;
        this.checkValidity();
    }

    private void checkValidity() {
        Utils.checkField(this.name, "name", "Release");
        Utils.checkField(this.mainUrl, "mainUrl", "Release");
        Utils.checkField(this.versionRange, "versionRange", "Release");
        Version.isValid(this.name, true);
        Utils.checkGithubURI(this.mainUrl);
        Release.checkURIHostValidity(this.requiredDependencyUrls);
        Release.checkURIHostValidity(this.optionalDependencyUrls);
        Release.checkURIHostValidity(this.javadocUrls);
    }

    private static void checkURIHostValidity(List<URI> uris) {
        if (uris != null) {
            for (URI uri : uris) {
                if (!VALID_SCHEME.equalsIgnoreCase(uri.getScheme())) {
                    throw new IllegalArgumentException(String.format("The URL %s must use %s", uri, VALID_SCHEME));
                }
                if (VALID_HOSTS.contains(uri.getHost())) continue;
                throw new IllegalArgumentException(String.format("The host part of %s is not among %s", uri, VALID_HOSTS));
            }
        }
    }
}

