/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.extensionmanager.core.catalog;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import qupath.ext.extensionmanager.core.Version;
import qupath.ext.extensionmanager.core.catalog.Release;
import qupath.ext.extensionmanager.core.catalog.Utils;

public record Extension(String name, String description, String author, URI homepage, boolean starred, List<Release> releases) {
    public Extension(String name, String description, String author, URI homepage, boolean starred, List<Release> releases) {
        this.name = name;
        this.description = description;
        this.author = author;
        this.homepage = homepage;
        this.starred = starred;
        this.releases = releases == null ? null : Collections.unmodifiableList(releases);
        this.checkValidity();
    }

    public Optional<Release> getMaxCompatibleRelease(String version) {
        Release maxCompatibleRelease = null;
        for (Release release : this.releases) {
            if (!release.versionRange().isCompatible(version) || maxCompatibleRelease != null && new Version(release.name()).compareTo(new Version(maxCompatibleRelease.name())) <= 0) continue;
            maxCompatibleRelease = release;
        }
        return Optional.ofNullable(maxCompatibleRelease);
    }

    private void checkValidity() {
        Utils.checkField(this.name, "name", "Extension");
        Utils.checkField(this.description, "description", "Extension");
        Utils.checkField(this.author, "author", "Extension");
        Utils.checkField(this.homepage, "homepage", "Extension");
        Utils.checkField(this.releases, "releases", "Extension");
        Utils.checkGithubURI(this.homepage);
    }
}

