/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.extensionmanager.core.catalog;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import qupath.ext.extensionmanager.core.catalog.Extension;
import qupath.ext.extensionmanager.core.catalog.Utils;

public record Catalog(String name, String description, List<Extension> extensions) {
    public Catalog(String name, String description, List<Extension> extensions) {
        this.name = name;
        this.description = description;
        this.extensions = extensions == null ? null : Collections.unmodifiableList(extensions);
        this.checkValidity();
    }

    private void checkValidity() {
        Utils.checkField(this.name, "name", "Catalog");
        Utils.checkField(this.description, "description", "Catalog");
        Utils.checkField(this.extensions, "extensions", "Catalog");
        if (this.extensions.stream().map(Extension::name).collect(Collectors.toSet()).size() < this.extensions.size()) {
            throw new IllegalArgumentException(String.format("At least two extensions of %s have the same name", this.extensions));
        }
    }
}

