/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.extensionmanager.core;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version
implements Comparable<Version> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^v(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(?:-rc(\\d+))?");
    private final int major;
    private final int minor;
    private final int patch;
    private final int releaseCandidate;

    public Version(String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.find()) {
            throw new IllegalArgumentException(String.format("Version not found in %s", version));
        }
        this.major = Integer.parseInt(matcher.group(1));
        this.minor = matcher.group(2) == null ? -1 : Integer.parseInt(matcher.group(2));
        this.patch = matcher.group(3) == null ? -1 : Integer.parseInt(matcher.group(3));
        this.releaseCandidate = matcher.group(4) == null ? -1 : Integer.parseInt(matcher.group(4));
    }

    public String toString() {
        StringBuilder version = new StringBuilder("v");
        version.append(this.major);
        if (this.minor > -1) {
            version.append(".");
            version.append(this.minor);
        }
        if (this.patch > -1) {
            version.append(".");
            version.append(this.patch);
        }
        if (this.releaseCandidate > -1) {
            version.append("-rc");
            version.append(this.releaseCandidate);
        }
        return version.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version version = (Version)obj;
        return this.major == version.major && this.minor == version.minor && this.patch == version.patch && this.releaseCandidate == version.releaseCandidate;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.releaseCandidate);
    }

    @Override
    public int compareTo(Version version) {
        if (this.major != version.major) {
            return this.major - version.major;
        }
        if (this.minor < 0 || version.minor < 0) {
            return 0;
        }
        if (this.minor != version.minor) {
            return this.minor - version.minor;
        }
        if (this.patch < 0 || version.patch < 0) {
            return 0;
        }
        if (this.patch != version.patch) {
            return this.patch - version.patch;
        }
        if (this.releaseCandidate != -1 && version.releaseCandidate != -1) {
            return this.releaseCandidate - version.releaseCandidate;
        }
        if (this.releaseCandidate != -1) {
            return -1;
        }
        if (version.releaseCandidate != -1) {
            return 1;
        }
        return 0;
    }

    public static void isValid(String text, boolean includeMinorAndPath) {
        Version version = new Version(text);
        if (includeMinorAndPath && (version.minor < 0 || version.patch < 0)) {
            throw new IllegalArgumentException(String.format("The provided version %s doesn't have a minor or patch number", text));
        }
    }
}

