/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.extensionmanager.core;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExtensionClassLoader
extends URLClassLoader {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionClassLoader.class);
    private final Set<String> filenamesAdded = new HashSet<String>();
    private final List<Runnable> runnables = new ArrayList<Runnable>();

    public ExtensionClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJar(Path jarPath) throws MalformedURLException {
        ArrayList<Runnable> runnables;
        ExtensionClassLoader extensionClassLoader = this;
        synchronized (extensionClassLoader) {
            this.addURL(jarPath.toUri().toURL());
            logger.debug("File {} loaded by extension class loader", (Object)jarPath);
            String filename = jarPath.getFileName().toString();
            if (this.filenamesAdded.contains(filename)) {
                logger.warn("A JAR file with the same file name ({}) was already added to this class loader. {} will probably not be loaded", (Object)filename, (Object)jarPath);
            }
            this.filenamesAdded.add(filename);
        }
        ExtensionClassLoader extensionClassLoader2 = this;
        synchronized (extensionClassLoader2) {
            runnables = new ArrayList<Runnable>(this.runnables);
        }
        for (Runnable runnable : runnables) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                logger.error("Error when calling runnable of class loader", (Throwable)e);
            }
        }
    }

    public synchronized void removeJar(Path jarPath) {
        this.filenamesAdded.remove(jarPath.getFileName().toString());
    }

    public synchronized void addOnJarLoadedRunnable(Runnable runnable) {
        this.runnables.add(Objects.requireNonNull(runnable));
    }
}

