/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.extensionmanager.core;

import java.io.IOError;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.ext.extensionmanager.core.ExtensionClassLoader;
import qupath.ext.extensionmanager.core.ExtensionFolderManager;
import qupath.ext.extensionmanager.core.Version;
import qupath.ext.extensionmanager.core.catalog.CatalogFetcher;
import qupath.ext.extensionmanager.core.catalog.Extension;
import qupath.ext.extensionmanager.core.catalog.Release;
import qupath.ext.extensionmanager.core.savedentities.InstalledExtension;
import qupath.ext.extensionmanager.core.savedentities.Registry;
import qupath.ext.extensionmanager.core.savedentities.SavedCatalog;
import qupath.ext.extensionmanager.core.savedentities.UpdateAvailable;
import qupath.ext.extensionmanager.core.tools.FileDownloader;
import qupath.ext.extensionmanager.core.tools.FileTools;
import qupath.ext.extensionmanager.core.tools.ZipExtractor;

public class ExtensionCatalogManager
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionCatalogManager.class);
    private final ObservableList<SavedCatalog> savedCatalogs = FXCollections.observableList(new CopyOnWriteArrayList());
    private final ObservableList<SavedCatalog> savedCatalogsImmutable = FXCollections.unmodifiableObservableList(this.savedCatalogs);
    private final Map<CatalogExtension, ObjectProperty<Optional<InstalledExtension>>> installedExtensions = new ConcurrentHashMap<CatalogExtension, ObjectProperty<Optional<InstalledExtension>>>();
    private final ExtensionFolderManager extensionFolderManager;
    private final ExtensionClassLoader extensionClassLoader;
    private final String version;
    private final Registry defaultRegistry;

    public ExtensionCatalogManager(ReadOnlyObjectProperty<Path> extensionDirectoryPath, ClassLoader parentClassLoader, String version, Registry defaultRegistry) {
        Version.isValid(version, true);
        this.extensionFolderManager = new ExtensionFolderManager(extensionDirectoryPath);
        this.extensionClassLoader = new ExtensionClassLoader(parentClassLoader);
        this.version = version;
        this.defaultRegistry = defaultRegistry;
        this.setCatalogsFromRegistry();
        extensionDirectoryPath.addListener((p, o, n) -> {
            this.setCatalogsFromRegistry();
            ExtensionCatalogManager extensionCatalogManager = this;
            synchronized (extensionCatalogManager) {
                for (CatalogExtension catalogExtension : this.installedExtensions.keySet()) {
                    this.installedExtensions.get(catalogExtension).set(this.getInstalledExtension(catalogExtension));
                }
            }
        });
        this.loadJars();
    }

    @Override
    public void close() throws Exception {
        this.extensionFolderManager.close();
        this.extensionClassLoader.close();
    }

    public ReadOnlyObjectProperty<Path> getExtensionDirectoryPath() {
        return this.extensionFolderManager.getExtensionDirectoryPath();
    }

    public String getVersion() {
        return this.version;
    }

    public Path getCatalogDirectory(SavedCatalog savedCatalog) throws IOException {
        return this.extensionFolderManager.getCatalogDirectoryPath(savedCatalog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCatalog(List<SavedCatalog> savedCatalogs) throws IOException {
        List<SavedCatalog> catalogsToAdd;
        if (savedCatalogs.stream().map(SavedCatalog::name).collect(Collectors.toSet()).size() < savedCatalogs.size()) {
            throw new IllegalArgumentException(String.format("Two of the provided catalogs %s have the same name", savedCatalogs));
        }
        if (this.getExtensionDirectoryPath().get() == null) {
            throw new NullPointerException("The extension directory path is null");
        }
        ExtensionCatalogManager extensionCatalogManager = this;
        synchronized (extensionCatalogManager) {
            catalogsToAdd = savedCatalogs.stream().filter(savedCatalog -> {
                if (this.savedCatalogs.stream().noneMatch(catalog -> catalog.name().equals(savedCatalog.name()))) {
                    return true;
                }
                logger.warn("{} has the same name as an existing catalog and will not be added", (Object)savedCatalog.name());
                return false;
            }).toList();
            if (catalogsToAdd.isEmpty()) {
                logger.debug("No catalog to add");
                return;
            }
            this.savedCatalogs.addAll(catalogsToAdd);
        }
        try {
            this.extensionFolderManager.saveRegistry(new Registry((List<SavedCatalog>)this.savedCatalogs));
        }
        catch (IOException | NullPointerException | SecurityException e) {
            this.savedCatalogs.removeAll(catalogsToAdd);
            throw e;
        }
        logger.info("Catalogs {} added", catalogsToAdd.stream().map(SavedCatalog::name).toList());
    }

    public ObservableList<SavedCatalog> getCatalogs() {
        return this.savedCatalogsImmutable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCatalogs(List<SavedCatalog> savedCatalogs, boolean removeExtensions) throws IOException {
        if (this.getExtensionDirectoryPath().get() == null) {
            throw new NullPointerException("The extension directory path is null");
        }
        List<SavedCatalog> catalogsToRemove = savedCatalogs.stream().filter(savedCatalog -> {
            if (savedCatalog.deletable()) {
                return true;
            }
            logger.warn("{} is not deletable and won't be deleted", (Object)savedCatalog.name());
            return false;
        }).toList();
        if (catalogsToRemove.isEmpty()) {
            logger.debug("No catalog to remove");
            return;
        }
        this.savedCatalogs.removeAll(catalogsToRemove);
        try {
            this.extensionFolderManager.saveRegistry(new Registry((List<SavedCatalog>)this.savedCatalogs));
        }
        catch (IOException | NullPointerException | SecurityException e) {
            this.savedCatalogs.addAll(catalogsToRemove);
            throw e;
        }
        if (removeExtensions) {
            for (SavedCatalog savedCatalog2 : catalogsToRemove) {
                try {
                    this.extensionFolderManager.deleteExtensionsFromCatalog(savedCatalog2);
                }
                catch (IOException | NullPointerException | SecurityException | InvalidPathException e) {
                    logger.debug("Could not delete {}", (Object)savedCatalog2.name(), (Object)e);
                }
            }
            for (Map.Entry entry : this.installedExtensions.entrySet()) {
                if (!catalogsToRemove.contains(((CatalogExtension)entry.getKey()).savedCatalog)) continue;
                ExtensionCatalogManager extensionCatalogManager = this;
                synchronized (extensionCatalogManager) {
                    ((ObjectProperty)entry.getValue()).set(Optional.empty());
                }
            }
        }
        logger.info("Catalogs {} removed", catalogsToRemove.stream().map(SavedCatalog::name).toList());
    }

    public Path getExtensionDirectory(SavedCatalog savedCatalog, Extension extension) throws IOException {
        return this.extensionFolderManager.getExtensionDirectoryPath(savedCatalog, extension);
    }

    public List<URI> getDownloadLinks(SavedCatalog savedCatalog, Extension extension, InstalledExtension installationInformation) throws IOException {
        return this.getDownloadUrlsToFilePaths(savedCatalog, extension, installationInformation, false).stream().map(UriFileName::uri).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installOrUpdateExtension(SavedCatalog savedCatalog, Extension extension, InstalledExtension installationInformation, Consumer<Float> onProgress, BiConsumer<InstallationStep, String> onStatusChanged) throws IOException, InterruptedException {
        ObjectProperty extensionProperty = this.installedExtensions.computeIfAbsent(new CatalogExtension(savedCatalog, extension), e -> new SimpleObjectProperty());
        logger.debug("Deleting files of {} before installing or updating it", (Object)extension.name());
        this.extensionFolderManager.deleteExtension(savedCatalog, extension);
        ExtensionCatalogManager extensionCatalogManager = this;
        synchronized (extensionCatalogManager) {
            extensionProperty.set(Optional.empty());
        }
        try {
            this.downloadAndExtractLinks(this.getDownloadUrlsToFilePaths(savedCatalog, extension, installationInformation, true), onProgress, onStatusChanged);
        }
        catch (Exception e2) {
            logger.debug("Installation of {} failed. Clearing extension files", (Object)extension.name());
            this.extensionFolderManager.deleteExtension(savedCatalog, extension);
            throw e2;
        }
        extensionCatalogManager = this;
        synchronized (extensionCatalogManager) {
            extensionProperty.set(Optional.of(installationInformation));
        }
        logger.info("{} of {} installed", (Object)extension.name(), (Object)savedCatalog.name());
    }

    public ReadOnlyObjectProperty<Optional<InstalledExtension>> getInstalledExtension(SavedCatalog savedCatalog, Extension extension) {
        return (ReadOnlyObjectProperty)this.installedExtensions.computeIfAbsent(new CatalogExtension(savedCatalog, extension), catalogExtension -> new SimpleObjectProperty(this.getInstalledExtension((CatalogExtension)catalogExtension)));
    }

    public ObservableList<Path> getCatalogManagedInstalledJars() {
        return this.extensionFolderManager.getCatalogManagedInstalledJars();
    }

    public ClassLoader getExtensionClassLoader() {
        return this.extensionClassLoader;
    }

    public void addOnJarLoadedRunnable(Runnable runnable) {
        this.extensionClassLoader.addOnJarLoadedRunnable(runnable);
    }

    public CompletableFuture<List<UpdateAvailable>> getAvailableUpdates() {
        return CompletableFuture.supplyAsync(() -> this.savedCatalogs.stream().map(savedCatalog -> CatalogFetcher.getCatalog(savedCatalog.rawUri()).join().extensions().stream().map(extension -> this.getUpdateAvailable((SavedCatalog)savedCatalog, (Extension)extension)).filter(Objects::nonNull).toList()).flatMap(Collection::stream).toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExtension(SavedCatalog savedCatalog, Extension extension) throws IOException {
        ObjectProperty extensionProperty = this.installedExtensions.computeIfAbsent(new CatalogExtension(savedCatalog, extension), e -> new SimpleObjectProperty());
        this.extensionFolderManager.deleteExtension(savedCatalog, extension);
        ExtensionCatalogManager extensionCatalogManager = this;
        synchronized (extensionCatalogManager) {
            extensionProperty.set(Optional.empty());
        }
        logger.info("{} of {} removed", (Object)extension.name(), (Object)savedCatalog.name());
    }

    public ObservableList<Path> getManuallyInstalledJars() {
        return this.extensionFolderManager.getManuallyInstalledJars();
    }

    private synchronized void setCatalogsFromRegistry() {
        block2: {
            this.savedCatalogs.clear();
            try {
                this.savedCatalogs.addAll(this.extensionFolderManager.getSavedRegistry().catalogs());
                logger.debug("Catalogs set from saved registry");
            }
            catch (Exception e) {
                logger.debug("Error while retrieving saved registry. Using default one", (Throwable)e);
                if (this.defaultRegistry == null) break block2;
                this.savedCatalogs.addAll(this.defaultRegistry.catalogs());
                logger.debug("Catalogs {} set from default registry", this.defaultRegistry.catalogs().stream().map(SavedCatalog::name).toList());
            }
        }
    }

    private Optional<InstalledExtension> getInstalledExtension(CatalogExtension catalogExtension) {
        try {
            return this.extensionFolderManager.getInstalledExtension(catalogExtension.savedCatalog, catalogExtension.extension);
        }
        catch (IOException | NullPointerException | SecurityException | InvalidPathException e) {
            logger.debug("Error while retrieving {} installation information", (Object)catalogExtension.extension.name(), (Object)e);
            return Optional.empty();
        }
    }

    private void loadJars() {
        this.addJars((List<? extends Path>)this.extensionFolderManager.getManuallyInstalledJars());
        this.extensionFolderManager.getManuallyInstalledJars().addListener(change -> {
            while (change.next()) {
                this.addJars(change.getAddedSubList());
                this.removeJars(change.getRemoved());
            }
            change.reset();
        });
        this.addJars((List<? extends Path>)this.extensionFolderManager.getCatalogManagedInstalledJars());
        this.extensionFolderManager.getCatalogManagedInstalledJars().addListener(change -> {
            while (change.next()) {
                this.addJars(change.getAddedSubList());
                this.removeJars(change.getRemoved());
            }
            change.reset();
        });
    }

    private List<UriFileName> getDownloadUrlsToFilePaths(SavedCatalog savedCatalog, Extension extension, InstalledExtension installationInformation, boolean createFolders) throws IOException {
        ArrayList<UriFileName> downloadUrlToFilePaths = new ArrayList<UriFileName>();
        Optional<Release> release = extension.releases().stream().filter(r -> r.name().equals(installationInformation.releaseName())).findAny();
        if (release.isEmpty()) {
            throw new IllegalArgumentException(String.format("The provided release name %s is not present in the extension releases %s", installationInformation.releaseName(), extension.releases()));
        }
        downloadUrlToFilePaths.add(new UriFileName(release.get().mainUrl(), Paths.get(this.extensionFolderManager.getExtensionPath(savedCatalog, extension, release.get().name(), ExtensionFolderManager.FileType.MAIN_JAR, createFolders).toString(), FileTools.getFileNameFromURI(release.get().mainUrl()))));
        for (URI javadocUri : release.get().javadocUrls()) {
            downloadUrlToFilePaths.add(new UriFileName(javadocUri, Paths.get(this.extensionFolderManager.getExtensionPath(savedCatalog, extension, release.get().name(), ExtensionFolderManager.FileType.JAVADOCS, createFolders).toString(), FileTools.getFileNameFromURI(javadocUri))));
        }
        for (URI requiredDependencyUri : release.get().requiredDependencyUrls()) {
            downloadUrlToFilePaths.add(new UriFileName(requiredDependencyUri, Paths.get(this.extensionFolderManager.getExtensionPath(savedCatalog, extension, release.get().name(), ExtensionFolderManager.FileType.REQUIRED_DEPENDENCIES, createFolders).toString(), FileTools.getFileNameFromURI(requiredDependencyUri))));
        }
        if (installationInformation.optionalDependenciesInstalled()) {
            for (URI optionalDependencyUri : release.get().optionalDependencyUrls()) {
                downloadUrlToFilePaths.add(new UriFileName(optionalDependencyUri, Paths.get(this.extensionFolderManager.getExtensionPath(savedCatalog, extension, release.get().name(), ExtensionFolderManager.FileType.OPTIONAL_DEPENDENCIES, createFolders).toString(), FileTools.getFileNameFromURI(optionalDependencyUri))));
            }
        }
        return downloadUrlToFilePaths;
    }

    private void downloadAndExtractLinks(List<UriFileName> downloadUrlToFilePath, Consumer<Float> onProgress, BiConsumer<InstallationStep, String> onStatusChanged) throws IOException, InterruptedException {
        int i = 0;
        for (UriFileName uriFileName : downloadUrlToFilePath) {
            float progressOffset = (float)i / (float)downloadUrlToFilePath.size();
            boolean downloadingZipArchive = uriFileName.filePath().toString().endsWith(".zip");
            if (downloadingZipArchive) {
                logger.debug("Downloading and extracting {} to {}", (Object)uriFileName.uri(), (Object)uriFileName.filePath());
            } else {
                logger.debug("Downloading {} to {}", (Object)uriFileName.uri(), (Object)uriFileName.filePath());
            }
            float step = downloadingZipArchive ? 1.0f / (float)(2 * downloadUrlToFilePath.size()) : 1.0f / (float)downloadUrlToFilePath.size();
            onStatusChanged.accept(InstallationStep.DOWNLOADING, uriFileName.uri().toString());
            FileDownloader.downloadFile(uriFileName.uri(), uriFileName.filePath(), progress -> onProgress.accept(Float.valueOf(progressOffset + progress.floatValue() * step)));
            if (downloadingZipArchive) {
                onStatusChanged.accept(InstallationStep.EXTRACTING_ZIP, uriFileName.filePath().toString());
                ZipExtractor.extractZipToFolder(uriFileName.filePath(), uriFileName.filePath().getParent(), progress -> onProgress.accept(Float.valueOf(progressOffset + step + progress.floatValue() * step)));
            }
            ++i;
        }
    }

    private UpdateAvailable getUpdateAvailable(SavedCatalog savedCatalog, Extension extension) {
        Optional<InstalledExtension> installedExtension = this.getInstalledExtension(new CatalogExtension(savedCatalog, extension));
        if (installedExtension.isPresent()) {
            String installedRelease = installedExtension.get().releaseName();
            Optional<Release> maxCompatibleRelease = extension.getMaxCompatibleRelease(this.version);
            if (maxCompatibleRelease.isPresent() && new Version(maxCompatibleRelease.get().name()).compareTo(new Version(installedRelease)) > 0) {
                logger.debug("{} installed and updatable to {}", (Object)extension.name(), (Object)maxCompatibleRelease.get().name());
                return new UpdateAvailable(extension.name(), installedExtension.get().releaseName(), maxCompatibleRelease.get().name());
            }
            logger.debug("{} installed but no compatible update found", (Object)extension.name());
            return null;
        }
        logger.debug("{} not installed, so no update available", (Object)extension.name());
        return null;
    }

    private void addJars(List<? extends Path> jarPaths) {
        for (Path path : jarPaths) {
            try {
                this.extensionClassLoader.addJar(path);
            }
            catch (IOError | SecurityException | MalformedURLException e) {
                logger.error("Cannot load extension {}", (Object)path, (Object)e);
            }
        }
    }

    private void removeJars(List<? extends Path> jarPaths) {
        for (Path path : jarPaths) {
            this.extensionClassLoader.removeJar(path);
        }
    }

    private record CatalogExtension(SavedCatalog savedCatalog, Extension extension) {
    }

    private record UriFileName(URI uri, Path filePath) {
    }

    public static enum InstallationStep {
        DOWNLOADING,
        EXTRACTING_ZIP;

    }
}

