/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers.openslide.jna;

import com.sun.jna.Native;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.images.servers.openslide.jna.OpenSlide;
import qupath.lib.images.servers.openslide.jna.OpenSlideJNA;

public class OpenSlideLoader {
    private static final Logger logger = LoggerFactory.getLogger(OpenSlideLoader.class);
    private static OpenSlideJNA INSTANCE;
    private static String LIBRARY_VERSION;

    public static boolean tryToLoadQuietly(String ... searchPath) {
        try {
            return OpenSlideLoader.tryToLoad(searchPath);
        }
        catch (Throwable t) {
            logger.debug("Unable to load OpenSlide", t);
            return false;
        }
    }

    public static synchronized boolean tryToLoad(String ... searchPath) throws UnsatisfiedLinkError {
        if (INSTANCE != null) {
            return true;
        }
        INSTANCE = OpenSlideLoader.tryToLoadJnaInstance(searchPath);
        return INSTANCE != null;
    }

    private static synchronized OpenSlideJNA tryToLoadJnaInstance(String ... searchPath) {
        if (searchPath.length == 0 || searchPath.length == 1 && searchPath[0].isEmpty()) {
            logger.debug("No search path provided; trying to load OpenSlide from packaged jar");
            try {
                File openslideFile = Native.extractFromResourcePath((String)"openslide");
                return (OpenSlideJNA)Native.load((String)openslideFile.getAbsolutePath(), OpenSlideJNA.class);
            }
            catch (IOException e) {
                logger.error("No OpenSlide search path supplied and failed to load OpenSlide from packaged jar! OpenSlide will not work.", (Throwable)e);
            }
        }
        String jnaPath = System.getProperty("jna.library.path", null);
        try {
            String path;
            if (searchPath.length > 0 && !(path = Arrays.stream(searchPath).filter(s -> s != null && !s.isBlank()).filter(s -> new File((String)s).isDirectory()).collect(Collectors.joining(File.pathSeparator))).isBlank()) {
                System.setProperty("jna.library.path", String.join((CharSequence)File.pathSeparator, path));
            }
            OpenSlideJNA openSlideJNA = (OpenSlideJNA)Native.load((String)"openslide", OpenSlideJNA.class);
            return openSlideJNA;
        }
        finally {
            if (jnaPath == null) {
                System.clearProperty("jna.library.path");
            } else {
                System.setProperty("jna.library.path", jnaPath);
            }
        }
    }

    public static String getLibraryVersion() {
        if (LIBRARY_VERSION == null) {
            OpenSlideLoader.tryToLoadQuietly(new String[0]);
            if (INSTANCE != null) {
                LIBRARY_VERSION = INSTANCE.openslide_get_version();
            }
        }
        return LIBRARY_VERSION;
    }

    public static boolean isOpenSlideAvailable() {
        return INSTANCE != null;
    }

    public static OpenSlide openImage(String path) throws IOException {
        if (INSTANCE == null) {
            OpenSlideLoader.tryToLoadQuietly(new String[0]);
        }
        if (INSTANCE == null) {
            throw new IOException("OpenSlide library not available");
        }
        return new OpenSlide(INSTANCE, path);
    }

    public static String detectVendor(String path) {
        if (INSTANCE == null) {
            OpenSlideLoader.tryToLoadQuietly(new String[0]);
        }
        if (INSTANCE == null) {
            return null;
        }
        return INSTANCE.openslide_detect_vendor(path);
    }

    static {
        LIBRARY_VERSION = null;
    }
}

