/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers.openslide.jna;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.images.servers.openslide.jna.OpenSlideJNA;

public final class OpenSlide
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(OpenSlide.class);
    public static final String PROPERTY_NAME_COMMENT = "openslide.comment";
    public static final String PROPERTY_NAME_VENDOR = "openslide.vendor";
    public static final String PROPERTY_NAME_QUICKHASH1 = "openslide.quickhash-1";
    public static final String PROPERTY_NAME_BACKGROUND_COLOR = "openslide.background-color";
    public static final String PROPERTY_NAME_OBJECTIVE_POWER = "openslide.objective-power";
    public static final String PROPERTY_NAME_MPP_X = "openslide.mpp-x";
    public static final String PROPERTY_NAME_MPP_Y = "openslide.mpp-y";
    public static final String PROPERTY_NAME_BOUNDS_X = "openslide.bounds-x";
    public static final String PROPERTY_NAME_BOUNDS_Y = "openslide.bounds-y";
    public static final String PROPERTY_NAME_BOUNDS_WIDTH = "openslide.bounds-width";
    public static final String PROPERTY_NAME_BOUNDS_HEIGHT = "openslide.bounds-height";
    private final List<String> associatedImages;
    private long osr;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final long[] levelWidths;
    private final long[] levelHeights;
    private final int levelCount;
    private final Map<String, String> properties;
    private OpenSlideJNA jna;

    OpenSlide(OpenSlideJNA jna, String path) throws IOException {
        Objects.requireNonNull(jna, "OpenSlide JNA instance cannot be null");
        this.jna = jna;
        logger.trace("Initializing OpenSlide for {}", (Object)path);
        this.osr = jna.openslide_open(path);
        if (this.osr == 0L) {
            throw new IOException(path + " is not a file that OpenSlide can recognize");
        }
        try {
            this.checkError();
        }
        catch (IOException e) {
            this.dispose();
            throw e;
        }
        this.levelCount = jna.openslide_get_level_count(this.osr);
        this.levelWidths = new long[this.levelCount];
        this.levelHeights = new long[this.levelCount];
        for (int i = 0; i < this.levelCount; ++i) {
            long[] lArray = new long[1];
            long[] h = new long[1];
            jna.openslide_get_level_dimensions(this.osr, i, lArray, h);
            this.levelWidths[i] = lArray[0];
            this.levelHeights[i] = h[0];
        }
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        for (String s : jna.openslide_get_property_names(this.osr)) {
            props.put(s, jna.openslide_get_property_value(this.osr, s));
        }
        this.properties = Collections.unmodifiableMap(props);
        this.associatedImages = new ArrayList<String>();
        Collections.addAll(this.associatedImages, jna.openslide_get_associated_image_names(this.osr));
        try {
            this.checkError();
        }
        catch (IOException iOException) {
            this.dispose();
            throw iOException;
        }
    }

    private void checkError() throws IOException {
        String msg = this.jna.openslide_get_error(this.osr);
        if (msg != null) {
            throw new IOException(msg);
        }
    }

    public void dispose() {
        Lock wl = this.lock.writeLock();
        wl.lock();
        try {
            if (this.osr != 0L) {
                this.jna.openslide_close(this.osr);
                this.osr = 0L;
            }
        }
        finally {
            wl.unlock();
        }
    }

    public int getLevelCount() {
        return this.levelCount;
    }

    private void checkNotDisposed() {
        if (this.osr == 0L) {
            throw new OpenSlideDisposedException();
        }
    }

    public long getLevel0Width() {
        return this.levelWidths[0];
    }

    public long getLevel0Height() {
        return this.levelHeights[0];
    }

    public long getLevelWidth(int level) {
        return this.levelWidths[level];
    }

    public long getLevelHeight(int level) {
        return this.levelHeights[level];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintRegionARGB(int[] dest, long x, long y, int level, int w, int h) throws IOException {
        if ((long)w * (long)h > (long)dest.length) {
            throw new ArrayIndexOutOfBoundsException("Size of data (" + dest.length + ") is less than w * h");
        }
        if (w < 0 || h < 0) {
            throw new IllegalArgumentException("w and h must be nonnegative");
        }
        Lock rl = this.lock.readLock();
        rl.lock();
        try {
            this.checkNotDisposed();
            this.jna.openslide_read_region(this.osr, dest, x, y, level, w, h);
            this.checkError();
        }
        finally {
            rl.unlock();
        }
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getAssociatedImage(String name) throws IOException {
        Lock rl = this.lock.readLock();
        rl.lock();
        try {
            this.checkNotDisposed();
            long[] d0 = new long[1];
            long[] d1 = new long[1];
            this.jna.openslide_get_associated_image_dimensions(this.osr, name, d0, d1);
            this.checkError();
            if (d0[0] == -1L) {
                throw new IOException("Failure reading associated image");
            }
            BufferedImage img = new BufferedImage((int)d0[0], (int)d1[0], 3);
            int[] data = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
            this.jna.openslide_read_associated_image(this.osr, name, data);
            this.checkError();
            BufferedImage bufferedImage = img;
            return bufferedImage;
        }
        finally {
            rl.unlock();
        }
    }

    public List<String> getAssociatedImages() {
        return this.associatedImages;
    }

    @Override
    public void close() {
        this.dispose();
    }

    public byte[] getICCProfileBytes() throws UnsupportedOperationException {
        Lock rl = this.lock.readLock();
        rl.lock();
        try {
            long size = this.jna.openslide_get_icc_profile_size(this.osr);
            if (size > 0L) {
                byte[] bytes = new byte[(int)size];
                this.jna.openslide_read_icc_profile(this.osr, bytes);
                byte[] byArray = bytes;
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        catch (UnsatisfiedLinkError e) {
            throw new UnsupportedOperationException("ICC Profile could not be found - OpenSlide version may not be compatible", e);
        }
        finally {
            rl.unlock();
        }
    }

    public static class OpenSlideDisposedException
    extends RuntimeException {
        private static final String MSG = "OpenSlide object has been disposed";

        public OpenSlideDisposedException() {
            super(MSG);
        }
    }
}

