/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers.openslide;

import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URI;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.LogTools;
import qupath.lib.images.servers.FileFormatInfo;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.openslide.OpenslideImageServer;
import qupath.lib.images.servers.openslide.jna.OpenSlideLoader;

public class OpenslideServerBuilder
implements ImageServerBuilder<BufferedImage> {
    private static final Logger logger = LoggerFactory.getLogger(OpenslideServerBuilder.class);
    private boolean failedToLoad = false;

    public ImageServer<BufferedImage> buildServer(URI uri, String ... args) {
        if (!OpenSlideLoader.isOpenSlideAvailable() && !OpenSlideLoader.tryToLoadQuietly(new String[0])) {
            logger.debug("OpenSlide is unavailable - will be skipped");
            return null;
        }
        try {
            return new OpenslideImageServer(uri, args);
        }
        catch (Exception e) {
            logger.error("Unable to open {} with OpenSlide: {}", new Object[]{uri, e.getMessage(), e});
        }
        catch (NoClassDefFoundError e) {
            logger.warn("OpenSlide library not found!");
            logger.debug(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public ImageServerBuilder.UriImageSupport<BufferedImage> checkImageSupport(URI uri, String ... args) {
        float supportLevel = this.supportLevel(uri, args);
        return ImageServerBuilder.UriImageSupport.createInstance(this.getClass(), (float)supportLevel, (ImageServerBuilder.ServerBuilder)ImageServerBuilder.DefaultImageServerBuilder.createInstance(this.getClass(), (URI)uri, (String[])args));
    }

    private float supportLevel(URI uri, String ... args) {
        if (!(OpenSlideLoader.isOpenSlideAvailable() || this.failedToLoad || OpenSlideLoader.tryToLoadQuietly(new String[0]))) {
            this.failedToLoad = true;
            return 0.0f;
        }
        FileFormatInfo.ImageCheckType type = FileFormatInfo.checkType((URI)uri);
        if (type.isURL() || type.getFile() == null) {
            return 0.0f;
        }
        try {
            File file = Paths.get(uri).toFile().getCanonicalFile();
            String vendor = OpenSlideLoader.detectVendor(file.toString());
            if (vendor == null) {
                return 0.0f;
            }
        }
        catch (Exception e) {
            logger.debug("Unable to read with OpenSlide: {}", (Object)e.getLocalizedMessage());
        }
        catch (UnsatisfiedLinkError e) {
            LogTools.warnOnce((Logger)logger, (String)("OpenSlide is not available (" + e.getLocalizedMessage() + ")"));
        }
        if (type.isNotRGB()) {
            return 1.0f;
        }
        if (type.nImagesLargest() == 1) {
            return 3.5f;
        }
        if (type.nImagesLargest() == -1) {
            return 2.5f;
        }
        return 1.0f;
    }

    public String getName() {
        return "OpenSlide builder";
    }

    public String getDescription() {
        return "Provides basic access to whole slide image formats supported by OpenSlide - see https://openslide.org";
    }

    public Class<BufferedImage> getImageType() {
        return BufferedImage.class;
    }

    public boolean matchClassName(String ... classNames) {
        for (String className : classNames) {
            if (!this.getClass().getName().equals(className) && !this.getClass().getSimpleName().equals(className) && !OpenslideImageServer.class.getName().equals(className) && !OpenslideImageServer.class.getSimpleName().equals(className) && !"openslide".equalsIgnoreCase(className)) continue;
            return true;
        }
        return false;
    }
}

