/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.openslide;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.localization.LocalizedResourceManager;
import qupath.fx.prefs.annotations.DirectoryPref;
import qupath.fx.prefs.annotations.PrefCategory;
import qupath.fx.prefs.controlsfx.PropertySheetUtils;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.extensions.QuPathExtension;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.images.servers.openslide.jna.OpenSlideLoader;

@PrefCategory(value="category.openslide")
public class OpenSlideExtension
implements QuPathExtension {
    private static final Logger logger = LoggerFactory.getLogger(OpenSlideExtension.class);
    @DirectoryPref(value="pref.openslide.path")
    public static final StringProperty openslidePathProperty = PathPrefs.createPersistentPreference((String)"openslide.path", (String)"");
    private final ChangeListener<String> openslidePathListener = this::handleOpenSlideDirectoryChange;

    public void installExtension(QuPathGUI qupath) {
        this.installPreferences(qupath);
        openslidePathProperty.addListener(this.openslidePathListener);
        if (!OpenSlideLoader.tryToLoadQuietly((String)openslidePathProperty.get())) {
            logger.warn("OpenSlide not found! Please specify the directory containing the OpenSlide library in the preferences.");
        } else {
            logger.info("OpenSlide loaded successfully: {}", (Object)OpenSlideLoader.getLibraryVersion());
        }
    }

    private void installPreferences(QuPathGUI qupath) {
        List prefs = PropertySheetUtils.parseAnnotatedItemsWithResources((LocalizedResourceManager)LocalizedResourceManager.createInstance((String)"qupath.ext.openslide.strings"), (Object)this);
        qupath.getPreferencePane().getPropertySheet().getItems().addAll((Collection)prefs);
    }

    private void handleOpenSlideDirectoryChange(ObservableValue<? extends String> value, String oldValue, String newValue) {
        block9: {
            if (!OpenSlideLoader.isOpenSlideAvailable() && newValue != null) {
                if (OpenSlideExtension.isPotentialOpenSlideDirectory(newValue)) {
                    try {
                        if (OpenSlideLoader.tryToLoad(newValue)) {
                            logger.info("OpenSlide loaded successfully: {}", (Object)OpenSlideLoader.getLibraryVersion());
                            Dialogs.showInfoNotification((String)"OpenSlide", (String)("OpenSlide loaded successfully: " + OpenSlideLoader.getLibraryVersion()));
                            break block9;
                        }
                        logger.warn("OpenSlide could not be loaded from {}", (Object)newValue);
                    }
                    catch (Throwable t) {
                        logger.debug("OpenSlide loading failed", t);
                    }
                }
            } else if (newValue != null && newValue.isEmpty()) {
                Dialogs.showInfoNotification((String)"OpenSlide", (String)"OpenSlide directory reset - please restart QuPath");
            } else if (OpenSlideExtension.isPotentialOpenSlideDirectory(newValue)) {
                Dialogs.showInfoNotification((String)"OpenSlide", (String)"OpenSlide directory updated - please restart QuPath");
            }
        }
    }

    private static boolean isPotentialOpenSlideDirectory(String path) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        File file = new File(path);
        if (!file.isDirectory()) {
            return false;
        }
        return Arrays.stream(file.listFiles()).filter(File::isFile).map(f -> f.getName().toLowerCase()).anyMatch(n -> n.contains("openslide"));
    }

    public String getName() {
        return "OpenSlide extension";
    }

    public String getDescription() {
        return "Provides support for OpenSlide images.\nThis includes specifying a path to an OpenSlide installation.";
    }
}

