/*
 * Decompiled with CFR 0.152.
 */
package qupath.ui.javadocviewer.gui.viewer;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Stage;
import javafx.stage.Window;
import qupath.ui.javadocviewer.gui.viewer.JavadocViewer;

public class JavadocViewerCommand
implements Runnable {
    private static final ResourceBundle resources = ResourceBundle.getBundle("qupath.ui.javadocviewer.strings");
    private final Stage owner;
    private final ReadOnlyStringProperty stylesheet;
    private final List<URI> urisToSearch;
    private Stage stage;
    private JavadocViewer javadocViewer;

    public JavadocViewerCommand(Stage owner, ReadOnlyStringProperty stylesheet, URI ... urisToSearch) {
        this.owner = owner;
        this.stylesheet = stylesheet;
        this.urisToSearch = Arrays.stream(urisToSearch).toList();
    }

    public JavadocViewer getJavadocViewer() {
        if (this.javadocViewer == null) {
            try {
                this.javadocViewer = new JavadocViewer(this.stylesheet, this.urisToSearch.toArray(new URI[0]));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.javadocViewer;
    }

    @Override
    public void run() {
        if (this.stage == null) {
            this.stage = new Stage();
            if (this.owner != null) {
                this.stage.initOwner((Window)this.owner);
            }
            this.stage.setTitle(resources.getString("JavadocViewer.title"));
            this.javadocViewer = this.getJavadocViewer();
            Scene scene = new Scene((Parent)this.javadocViewer);
            this.stage.setScene(scene);
            this.stage.show();
        }
        this.stage.show();
        this.stage.requestFocus();
    }
}

