/*
 * Decompiled with CFR 0.152.
 */
package qupath.ui.javadocviewer.gui.viewer;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebHistory;
import javafx.scene.web.WebView;
import qupath.ui.javadocviewer.core.Javadoc;
import qupath.ui.javadocviewer.core.JavadocElement;
import qupath.ui.javadocviewer.core.JavadocsFinder;
import qupath.ui.javadocviewer.gui.components.AutoCompletionTextField;
import qupath.ui.javadocviewer.gui.viewer.JavadocEntry;

public class JavadocViewer
extends BorderPane {
    private static final ResourceBundle resources = ResourceBundle.getBundle("qupath.ui.javadocviewer.strings");
    private static final Pattern REDIRECTION_PATTERN = Pattern.compile("window\\.location\\.replace\\(['\"](.*?)['\"]\\)");
    private static final List<String> CATEGORIES_TO_SKIP = List.of("package", "module", "Variable", "Exception", "Annotation", "Element");
    private final WebView webView = new WebView();
    @FXML
    private Button back;
    @FXML
    private Button forward;
    @FXML
    private ComboBox<URI> uris;
    @FXML
    private AutoCompletionTextField<JavadocEntry> autoCompletionTextField;

    public JavadocViewer(ReadOnlyStringProperty stylesheet, URI ... urisToSearch) throws IOException {
        this.initUI(stylesheet, Arrays.stream(urisToSearch).toList());
        this.setUpListeners();
    }

    public void setSearchInput(String input) {
        this.autoCompletionTextField.setText(input);
    }

    @FXML
    private void onBackClicked(ActionEvent ignoredEvent) {
        this.offset(-1);
    }

    @FXML
    private void onForwardClicked(ActionEvent ignoredEvent) {
        this.offset(1);
    }

    private void initUI(ReadOnlyStringProperty stylesheet, List<URI> urisToSearch) throws IOException {
        FXMLLoader loader = new FXMLLoader(JavadocViewer.class.getResource("javadoc_viewer.fxml"), resources);
        loader.setRoot((Object)this);
        loader.setController((Object)this);
        loader.load();
        this.setCenter((Node)this.webView);
        this.uris.setCellFactory(col -> new ListCell<URI>(this){

            protected void updateItem(URI item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(JavadocViewer.getName(item));
                }
            }
        });
        this.uris.setButtonCell((ListCell)new ListCell<URI>(this){

            protected void updateItem(URI item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (item == null || empty) {
                    this.setText(null);
                } else {
                    this.setText(JavadocViewer.getName(item));
                }
            }
        });
        if (stylesheet != null) {
            this.webView.getEngine().userStyleSheetLocationProperty().bind((ObservableValue)stylesheet);
        }
        this.webView.getEngine().loadContent(resources.getString("JavadocViewer.findingJavadocs"));
        JavadocsFinder.findJavadocs(urisToSearch.toArray(new URI[0])).thenAccept(javadocs -> Platform.runLater(() -> {
            this.uris.getItems().setAll(javadocs.stream().map(Javadoc::uri).sorted(Comparator.comparing(JavadocViewer::getName)).toList());
            if (this.uris.getItems().isEmpty()) {
                this.webView.getEngine().loadContent(resources.getString("JavadocViewer.noJavadocs"));
            } else {
                this.uris.getSelectionModel().select((Object)this.uris.getItems().stream().filter(u -> JavadocViewer.getName(u).toLowerCase().contains("qupath")).findFirst().orElse((URI)this.uris.getItems().getFirst()));
            }
            this.autoCompletionTextField.getSuggestions().addAll(javadocs.stream().map(Javadoc::elements).flatMap(Collection::stream).map(javadocElement -> new JavadocEntry((JavadocElement)javadocElement, () -> {
                this.updateSelectedUri(javadocElement.uri());
                this.webView.getEngine().load(javadocElement.uri().toString());
            })).filter(javadocEntry -> !CATEGORIES_TO_SKIP.contains(javadocEntry.getCategory())).toList());
        }));
    }

    private void setUpListeners() {
        this.back.disableProperty().bind((ObservableValue)this.webView.getEngine().getHistory().currentIndexProperty().isEqualTo(0));
        this.forward.disableProperty().bind((ObservableValue)this.webView.getEngine().getHistory().currentIndexProperty().greaterThanOrEqualTo((ObservableNumberValue)Bindings.size((ObservableList)this.webView.getEngine().getHistory().getEntries()).subtract(1)));
        this.uris.getSelectionModel().selectedItemProperty().addListener((p, o, n) -> {
            if (n != null && !this.webView.getEngine().getLocation().equals(n.toString())) {
                this.webView.getEngine().load(n.toString());
            }
        });
        this.webView.getEngine().documentProperty().addListener((p, o, n) -> {
            Matcher redirectionMatcher;
            if (n != null && (redirectionMatcher = REDIRECTION_PATTERN.matcher(n.getDocumentElement().getTextContent())).find() && redirectionMatcher.groupCount() > 0) {
                JavadocViewer.changeLocation(this.webView.getEngine().getLocation(), redirectionMatcher.group(1)).ifPresent(newLocation -> this.webView.getEngine().load(newLocation));
            }
        });
    }

    private void offset(int offset) {
        WebHistory history = this.webView.getEngine().getHistory();
        int index = history.getCurrentIndex() + offset;
        if (index >= 0 && index < history.getEntries().size()) {
            history.go(offset);
        }
    }

    private static String getName(URI uri) {
        Path path;
        String name;
        if ("jar".equals(uri.getScheme())) {
            uri = URI.create(uri.getRawSchemeSpecificPart());
        }
        if ((name = (path = Paths.get(uri)).getFileName().toString().toLowerCase()).endsWith(".html")) {
            String fileName = path.getParent().getFileName().toString();
            if (fileName.endsWith(".jar!")) {
                fileName = fileName.substring(0, fileName.length() - 1);
            }
            return fileName;
        }
        return name;
    }

    private void updateSelectedUri(URI uri) {
        int maxIndex = Integer.MIN_VALUE;
        URI closestUri = null;
        for (URI sd : this.uris.getItems()) {
            int index = JavadocViewer.getNumberOfCommonCharactersFromBeginning(uri.toString(), sd.toString());
            if (index <= maxIndex) continue;
            maxIndex = index;
            closestUri = sd;
        }
        if (closestUri != null) {
            this.uris.getSelectionModel().select(closestUri);
        }
    }

    private static Optional<String> changeLocation(String currentLocation, String newLocation) {
        int index = currentLocation.lastIndexOf("/");
        if (index == -1) {
            return Optional.empty();
        }
        return Optional.of(currentLocation.substring(0, currentLocation.lastIndexOf("/")) + "/" + newLocation);
    }

    private static int getNumberOfCommonCharactersFromBeginning(String text1, String text2) {
        int n = Math.min(text1.length(), text2.length());
        for (int i = 0; i < n; ++i) {
            if (text1.charAt(i) == text2.charAt(i)) continue;
            return i;
        }
        return n;
    }
}

