/*
 * Decompiled with CFR 0.152.
 */
package qupath.ui.javadocviewer.gui.viewer;

import java.util.Map;
import qupath.ui.javadocviewer.core.JavadocElement;
import qupath.ui.javadocviewer.gui.components.AutoCompleteTextFieldEntry;

class JavadocEntry
implements AutoCompleteTextFieldEntry {
    private static final Map<String, Integer> CATEGORY_ORDER = Map.of("Class", 1, "Interface", 2, "Enum", 3, "Constructor", 4, "Static", 5, "Method", 6);
    private final JavadocElement javadocElement;
    private final Runnable onSelected;
    private String searchableText;

    public JavadocEntry(JavadocElement javadocElement, Runnable onSelected) {
        this.javadocElement = javadocElement;
        this.onSelected = onSelected;
    }

    @Override
    public String getName() {
        return this.javadocElement.name();
    }

    @Override
    public String getSearchableText() {
        if (this.searchableText == null) {
            this.searchableText = switch (this.javadocElement.category()) {
                case "Class", "Interface" -> this.javadocElement.name().substring(this.javadocElement.name().lastIndexOf(".") + 1);
                case "Enum" -> {
                    int secondLastPointIndex;
                    int lastPointIndex = this.javadocElement.name().lastIndexOf(".");
                    if (lastPointIndex > -1 && (secondLastPointIndex = this.javadocElement.name().lastIndexOf(".", lastPointIndex - 1)) > -1) {
                        yield this.javadocElement.name().substring(secondLastPointIndex + 1);
                    }
                    yield this.javadocElement.name();
                }
                case "Static", "Method" -> {
                    int pointIndex = this.javadocElement.name().indexOf(".");
                    int parenthesisIndex = this.javadocElement.name().indexOf("(");
                    if (parenthesisIndex > -1) {
                        yield this.javadocElement.name().substring(pointIndex + 1, parenthesisIndex);
                    }
                    yield this.javadocElement.name().substring(pointIndex + 1);
                }
                case "Constructor" -> {
                    int parenthesisIndex = this.javadocElement.name().indexOf("(");
                    if (parenthesisIndex > -1) {
                        yield this.javadocElement.name().substring(0, parenthesisIndex);
                    }
                    yield this.javadocElement.name();
                }
                default -> this.javadocElement.name();
            };
        }
        return this.searchableText;
    }

    @Override
    public String getCategory() {
        return this.javadocElement.category();
    }

    @Override
    public void onSelected() {
        this.onSelected.run();
    }

    @Override
    public int compareTo(AutoCompleteTextFieldEntry otherEntry) {
        int categoryComparison = CATEGORY_ORDER.getOrDefault(this.getCategory(), 0) - CATEGORY_ORDER.getOrDefault(otherEntry.getCategory(), 0);
        if (categoryComparison != 0) {
            return categoryComparison;
        }
        return this.getName().compareTo(otherEntry.getName());
    }

    public String toString() {
        return String.format("Javadoc entry of %s", this.javadocElement);
    }
}

