/*
 * Decompiled with CFR 0.152.
 */
package qupath.ui.javadocviewer.gui.components;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.layout.Region;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import qupath.ui.javadocviewer.gui.components.AutoCompleteTextFieldEntry;

public class AutoCompletionTextField<T extends AutoCompleteTextFieldEntry>
extends TextField {
    private static final int MAX_ENTRIES = 100;
    private static final int MAX_POPUP_HEIGHT = 300;
    private final ContextMenu entriesPopup = new ContextMenu();
    private final List<T> suggestions = new ArrayList<T>();

    public AutoCompletionTextField() {
        this.setUpUI();
        this.setUpListeners();
    }

    public List<T> getSuggestions() {
        return this.suggestions;
    }

    private void setUpUI() {
        this.entriesPopup.setMaxHeight(300.0);
        this.entriesPopup.addEventHandler(Menu.ON_SHOWING, e -> {
            Node content = this.entriesPopup.getSkin().getNode();
            if (content instanceof Region) {
                Region region = (Region)content;
                region.setMaxHeight(this.entriesPopup.getMaxHeight());
            }
        });
    }

    private void setUpListeners() {
        this.textProperty().addListener((p, o, n) -> {
            String enteredText = this.getText();
            if (enteredText == null || enteredText.isEmpty()) {
                this.entriesPopup.hide();
            } else {
                String loweredCaseEnteredText = enteredText.toLowerCase();
                Comparator<AutoCompleteTextFieldEntry> comparator = Comparator.comparing(e -> e.getSearchableText().toLowerCase().equals(loweredCaseEnteredText) ? -1 : 1).thenComparing(e -> e.getSearchableText().toLowerCase().startsWith(loweredCaseEnteredText) ? -1 : 1).thenComparing(Comparable::compareTo);
                this.populatePopup(this.suggestions.stream().filter(entry -> entry.getSearchableText().toLowerCase().contains(loweredCaseEnteredText)).sorted(comparator).limit(100L).toList(), enteredText);
            }
        });
        this.focusedProperty().addListener((p, o, n) -> this.entriesPopup.hide());
    }

    private void populatePopup(List<T> entries, String filter) {
        if (entries.isEmpty()) {
            this.entriesPopup.hide();
        } else {
            List items = entries.stream().map(AutoCompleteTextFieldEntry::getCategory).distinct().flatMap(category -> Stream.concat(Stream.of(new CustomMenuItem(AutoCompletionTextField.createCategoryItemText(category), false)), entries.stream().filter(entry -> entry.getCategory().equals(category)).map(entry -> {
                CustomMenuItem menuItem = new CustomMenuItem(this.createEntryItemText(entry, filter), true);
                menuItem.setOnAction(actionEvent -> {
                    this.entriesPopup.hide();
                    entry.onSelected();
                });
                return menuItem;
            }))).toList();
            this.entriesPopup.getItems().clear();
            this.entriesPopup.getItems().add((Object)((MenuItem)items.getFirst()));
            this.entriesPopup.show((Node)this, Side.BOTTOM, 0.0, 0.0);
            this.entriesPopup.getItems().addAll(items.stream().skip(1L).toList());
        }
    }

    private static Node createCategoryItemText(String category) {
        Text text = new Text(category);
        text.getStyleClass().add((Object)"category-text");
        return text;
    }

    private Node createEntryItemText(T entry, String filter) {
        String searchableText = entry.getSearchableText();
        String text = entry.getName();
        int searchableTextIndex = text.indexOf(searchableText);
        int filterIndex = text.toLowerCase().indexOf(filter.toLowerCase(), searchableTextIndex);
        Text textBefore = new Text(text.substring(0, filterIndex));
        Text textFiltered = new Text(text.substring(filterIndex, filterIndex + filter.length()));
        Text textAfter = new Text(text.substring(filterIndex + filter.length()));
        textBefore.getStyleClass().add((Object)"regular-text");
        textFiltered.getStyleClass().add((Object)"highlighted-text");
        textAfter.getStyleClass().add((Object)"regular-text");
        return new TextFlow(new Node[]{textBefore, textFiltered, textAfter});
    }
}

