/*
 * Decompiled with CFR 0.152.
 */
package qupath.ui.javadocviewer.core;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.ui.javadocviewer.core.Javadoc;
import qupath.ui.javadocviewer.core.Utils;

public class JavadocsFinder {
    private static final Logger logger = LoggerFactory.getLogger(JavadocsFinder.class);
    private static final String JAVADOC_INDEX_FILE = "index.html";
    private static final List<String> ARCHIVE_EXTENSIONS = List.of(".jar", ".zip");
    private static final int SEARCH_DEPTH = 4;

    private JavadocsFinder() {
        throw new AssertionError((Object)"This class is not instantiable.");
    }

    public static CompletableFuture<List<Javadoc>> findJavadocs(URI ... urisToSearch) {
        return CompletableFuture.supplyAsync(() -> Arrays.stream(urisToSearch).map(JavadocsFinder::findJavadocUrisFromUri).flatMap(Collection::stream).map(uri -> {
            try {
                return Javadoc.create(uri).get();
            }
            catch (InterruptedException | ExecutionException e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                logger.debug("Error when creating javadoc of {}. Skipping it", uri, (Object)e);
                return null;
            }
        }).filter(Objects::nonNull).distinct().toList());
    }

    private static List<URI> findJavadocUrisFromUri(URI uri) {
        if (Utils.doesUrilinkToWebsite(uri)) {
            logger.debug("URI {} retrieved", (Object)uri);
            return List.of(uri);
        }
        try {
            return JavadocsFinder.findJavadocUrisFromPath(Paths.get(uri));
        }
        catch (Exception e) {
            logger.debug("Could not convert URI {} to path", (Object)uri, (Object)e);
            return List.of();
        }
    }

    private static List<URI> findJavadocUrisFromPath(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return JavadocsFinder.findJavadocUrisFromDirectory(path);
        }
        return JavadocsFinder.findJavadocUrisFromFile(path).map(List::of).orElse(List.of());
    }

    private static List<URI> findJavadocUrisFromDirectory(Path directory) {
        List<URI> list;
        block8: {
            logger.debug("Searching for javadocs in {} directory with depth {}", (Object)directory, (Object)4);
            Stream<Path> walk = Files.walk(directory, 4, new FileVisitOption[0]);
            try {
                list = walk.map(JavadocsFinder::findJavadocUrisFromFile).flatMap(Optional::stream).toList();
                if (walk == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.debug("Exception while searching for javadoc URIs", (Throwable)e);
                    return List.of();
                }
            }
            walk.close();
        }
        return list;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Optional<URI> findJavadocUrisFromFile(Path path) {
        block22: {
            Optional<String> extension;
            logger.debug("Determining if {} contains Javadoc", (Object)path);
            File file = path.toFile();
            if (JAVADOC_INDEX_FILE.equalsIgnoreCase(file.getName()) && List.of("javadoc", "javadocs", "docs").contains(file.getParentFile().getName().toLowerCase())) {
                try (Stream<String> lines = Files.lines(path);){
                    if (lines.anyMatch(l -> l.contains("javadoc"))) {
                        logger.debug("{} points to a Javadoc index page", (Object)path);
                        Optional<URI> optional = Optional.of(path.toUri());
                        return optional;
                    }
                }
                catch (IOException e) {
                    logger.debug("Error while reading {}", (Object)path, (Object)e);
                }
            }
            if ((extension = JavadocsFinder.getExtension(file.toString())).isPresent() && ARCHIVE_EXTENSIONS.contains(extension.get()) && file.getName().toLowerCase().endsWith("javadoc" + extension.get())) {
                try (ZipFile zipFile = new ZipFile(file);){
                    if (zipFile.getEntry(JAVADOC_INDEX_FILE) == null) break block22;
                    String uri = String.format("jar:%s!/%s", file.toURI(), JAVADOC_INDEX_FILE);
                    try {
                        logger.debug("{} is an archive containing Javadoc", (Object)uri);
                        Optional<URI> optional = Optional.of(new URI(uri));
                        return optional;
                    }
                    catch (URISyntaxException e) {
                        logger.warn("Error while creating URI {}", (Object)uri, (Object)e);
                    }
                }
                catch (IOException e) {
                    logger.warn("Error while reading {}", (Object)path, (Object)e);
                }
            }
        }
        logger.debug("{} doesn't contain Javadoc", (Object)path);
        return Optional.empty();
    }

    private static Optional<String> getExtension(String filename) {
        return Optional.ofNullable(filename).filter(f -> f.contains(".")).map(f -> f.substring(filename.lastIndexOf(".")));
    }
}

