/*
 * Decompiled with CFR 0.152.
 */
package qupath.ui.javadocviewer.core;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.ui.javadocviewer.core.JavadocElement;
import qupath.ui.javadocviewer.core.Utils;

public record Javadoc(URI uri, List<JavadocElement> elements) {
    private static final Logger logger = LoggerFactory.getLogger(Javadoc.class);
    private static final String INDEX_PAGE = "index.html";
    private static final String INDEX_ALL_PAGE = "index-all.html";
    private static final Pattern ENTRY_PATTERN = Pattern.compile("<dt>(.*?)</dt>");
    private static final Pattern URI_PATTERN = Pattern.compile("href=\"(.+?)\"");
    private static final Pattern NAME_PATTERN = Pattern.compile("<a .*?>(?:<span .*?>)?(.*?)(?:</span>)?</a>");
    private static final Pattern CATEGORY_PATTERN = Pattern.compile("</a> - (.+?) ");
    private static final int REQUEST_TIMEOUT_SECONDS = 10;

    public Javadoc(URI uri, List<JavadocElement> elements) {
        this.uri = uri;
        this.elements = Collections.unmodifiableList(elements);
    }

    public static CompletableFuture<Javadoc> create(URI uri) {
        return Javadoc.getIndexAllPage(uri).thenApply(indexAllPage -> new Javadoc(uri, Javadoc.parseJavadocIndexPage(uri.toString().substring(0, uri.toString().lastIndexOf(47) + 1), indexAllPage)));
    }

    private static CompletableFuture<String> getIndexAllPage(URI javadocIndexURI) {
        URI indexAllURI;
        String link = javadocIndexURI.toString().replace(INDEX_PAGE, INDEX_ALL_PAGE);
        try {
            indexAllURI = new URI(link);
        }
        catch (URISyntaxException e) {
            return CompletableFuture.failedFuture(e);
        }
        if (Utils.doesUrilinkToWebsite(indexAllURI)) {
            return Javadoc.getIndexAllPageContentFromHttp(indexAllURI);
        }
        return CompletableFuture.supplyAsync(() -> {
            if (indexAllURI.getScheme().contains("jar")) {
                return Javadoc.getIndexAllPageContentFromJar(indexAllURI);
            }
            return Javadoc.getIndexAllPageContentFromNonJar(indexAllURI);
        });
    }

    private static List<JavadocElement> parseJavadocIndexPage(String javadocURI, String indexHTMLPage) {
        ArrayList<JavadocElement> elements = new ArrayList<JavadocElement>();
        Matcher entryMatcher = ENTRY_PATTERN.matcher(indexHTMLPage);
        while (entryMatcher.find()) {
            if (entryMatcher.groupCount() <= 0) continue;
            Matcher uriMatcher = URI_PATTERN.matcher(entryMatcher.group(1));
            Matcher nameMatcher = NAME_PATTERN.matcher(entryMatcher.group(1));
            Matcher categoryMatcher = CATEGORY_PATTERN.matcher(entryMatcher.group(1));
            if (!uriMatcher.find() || uriMatcher.groupCount() <= 0 || !nameMatcher.find() || nameMatcher.groupCount() <= 0 || !categoryMatcher.find() || categoryMatcher.groupCount() <= 0) continue;
            Object name = nameMatcher.group(1).replace("&lt;", "<").replace("&gt;", ">");
            if (nameMatcher.find() && nameMatcher.groupCount() > 0) {
                name = nameMatcher.group(1) + "." + (String)name;
            }
            String link = javadocURI + uriMatcher.group(1);
            String category = categoryMatcher.group(1);
            name = Javadoc.correctNameIfConstructor((String)name, category);
            try {
                elements.add(new JavadocElement(new URI(link), (String)name, category));
            }
            catch (URISyntaxException e) {
                logger.debug("Cannot create URI {} of Javadoc element", (Object)link, (Object)e);
            }
        }
        return elements;
    }

    private static CompletableFuture<String> getIndexAllPageContentFromHttp(URI uri) {
        HttpClient httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
        logger.debug("Sending GET request to {} to read the index-all page content...", (Object)uri);
        return ((CompletableFuture)httpClient.sendAsync(HttpRequest.newBuilder().uri(uri).timeout(Duration.of(10L, ChronoUnit.SECONDS)).GET().build(), HttpResponse.BodyHandlers.ofString()).thenApply(response -> {
            logger.debug("Got response {} from {}", response, (Object)uri);
            return (String)response.body();
        })).whenComplete((b, e) -> httpClient.close());
    }

    /*
     * Exception decompiling
     */
    private static String getIndexAllPageContentFromJar(URI uri) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getIndexAllPageContentFromNonJar(URI uri) {
        String string;
        block8: {
            logger.debug("Reading {} file to get the index-all page content...", (Object)uri);
            Stream<String> lines = Files.lines(Paths.get(uri));
            try {
                string = lines.collect(Collectors.joining("\n"));
                if (lines == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lines != null) {
                        try {
                            lines.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            lines.close();
        }
        return string;
    }

    private static String correctNameIfConstructor(String name, String category) {
        if (category.equals("Constructor")) {
            int pointIndex = name.indexOf(".");
            return name.substring(pointIndex + 1);
        }
        return name;
    }
}

