/*
 * Decompiled with CFR 0.152.
 */
package qupath.ui.logviewer.ui.textarea;

import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.control.TextArea;
import qupath.ui.logviewer.api.LogMessage;
import qupath.ui.logviewer.api.listener.LoggerListener;
import qupath.ui.logviewer.api.manager.LoggerManager;

public class TextAreaLogViewer
extends TextArea
implements LoggerListener {
    private final LoggerManager loggerManager;

    public TextAreaLogViewer() {
        this(null);
    }

    public TextAreaLogViewer(LoggerManager loggerManager) {
        this.setEditable(false);
        this.loggerManager = loggerManager == null ? (LoggerManager)LoggerManager.getCurrentLoggerManager().orElse(null) : loggerManager;
        if (this.loggerManager == null) {
            this.appendText("No logging manager found");
        } else {
            this.startLogging();
        }
    }

    public void addLogMessage(LogMessage logMessage) {
        if (Platform.isFxApplicationThread()) {
            this.appendText(logMessage.toReadableString() + "\n");
        } else {
            Platform.runLater(() -> this.addLogMessage(logMessage));
        }
    }

    public void startLogging() {
        if (this.loggerManager == null) {
            throw new IllegalStateException("No logger manager found");
        }
        this.loggerManager.addListener((LoggerListener)this);
    }

    public void stopLogging() {
        if (this.loggerManager == null) {
            throw new IllegalStateException("No logger manager found");
        }
        this.loggerManager.removeListener((LoggerListener)this);
    }

    public Optional<LoggerManager> getLoggerManager() {
        return Optional.ofNullable(this.loggerManager);
    }
}

