/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.layout.responsivepane;

import javafx.scene.Scene;
import jfxtras.scene.layout.responsivepane.ResponsivePane;
import jfxtras.scene.layout.responsivepane.Size;
import jfxtras.scene.layout.responsivepane.Unit;

public class Width
extends Size {
    public static final Width ZERO = new Width(0.0, Unit.INCH);
    Unit unit;
    double value;

    Width(double value, Unit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    double toInches(ResponsivePane responsivePane) {
        Scene lScene = responsivePane.getScene();
        double lHeightInInches = lScene.getHeight() / responsivePane.determinePPI();
        double lWidthInInches = this.unit.toInches(this.value);
        double lDiagonalInInches = Math.sqrt(lWidthInInches * lWidthInInches + lHeightInInches * lHeightInInches);
        if (responsivePane.getTrace().booleanValue()) {
            System.out.println(this.toString() + " using the actual scene height of " + lHeightInInches + "in (" + lScene.getHeight() + "px), results in a diagonal of " + lDiagonalInInches + "in");
        }
        return lDiagonalInInches;
    }

    public static Width inch(double v) {
        return new Width(v, Unit.INCH);
    }

    public static Width cm(double v) {
        return new Width(v, Unit.CM);
    }

    public static Width valueOf(String s) {
        if (s.endsWith(Unit.INCH.suffix)) {
            return Width.inch(Double.parseDouble(s.substring(0, s.length() - Unit.INCH.suffix.length())));
        }
        if (s.endsWith(Unit.CM.suffix)) {
            return Width.cm(Double.parseDouble(s.substring(0, s.length() - Unit.CM.suffix.length())));
        }
        throw new IllegalArgumentException("Don't know how to parse '" + s + "'");
    }

    public String toString() {
        return "width=" + this.value + this.unit.suffix;
    }
}

