/*
 * Decompiled with CFR 0.152.
 */
package jfxtras.scene.layout;

import java.util.WeakHashMap;
import javafx.collections.ListChangeListener;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.Priority;
import jfxtras.scene.layout.GenericLayoutConstraints;

public class HBox
extends javafx.scene.layout.HBox {
    private WeakHashMap<Node, C> cMap = new WeakHashMap();

    public HBox() {
        this.construct();
    }

    public HBox(double spacing) {
        super(spacing);
        this.construct();
    }

    public HBox(double spacing, Node ... nodes) {
        super(spacing, nodes);
        this.construct();
    }

    public HBox(Node ... nodes) {
        super(nodes);
        this.construct();
    }

    private void construct() {
        this.getChildren().addListener((ListChangeListener)new ListChangeListener<Node>(){

            public void onChanged(ListChangeListener.Change<? extends Node> changes) {
                while (changes.next()) {
                    for (Node lNode : changes.getAddedSubList()) {
                        C lC = HBox.this.cMap.get(lNode);
                        if (lC == null) continue;
                        lC.apply(lNode);
                    }
                }
            }
        });
    }

    public HBox withSpacing(double value) {
        super.setSpacing(value);
        return this;
    }

    public HBox add(Node node) {
        this.getChildren().add((Object)node);
        return this;
    }

    public HBox add(Node node, C c) {
        this.cMap.put(node, c);
        c.rememberResetValues(node);
        this.getChildren().add((Object)node);
        return this;
    }

    public HBox remove(Node node) {
        this.getChildren().remove((Object)node);
        this.cMap.remove(node);
        return this;
    }

    public void setConstraint(Node node, C c) {
        this.cMap.put(node, c);
        c.rememberResetValues(node);
    }

    public void removeConstraintsFor(Node node) {
        this.cMap.remove(node);
    }

    public void removeNode(Node node) {
        this.getChildren().remove((Object)node);
    }

    public static class C
    extends GenericLayoutConstraints.C<C> {
        private Priority hgrow = null;
        private Priority hgrowReset = null;
        private Insets margin = null;
        private Insets marginReset = null;

        public C hgrow(Priority value) {
            this.hgrow = value;
            return this;
        }

        public C margin(Insets value) {
            this.margin = value;
            return this;
        }

        @Override
        protected void rememberResetValues(Node node) {
            super.rememberResetValues(node);
            this.hgrowReset = javafx.scene.layout.HBox.getHgrow((Node)node);
            this.marginReset = javafx.scene.layout.HBox.getMargin((Node)node);
        }

        @Override
        protected void apply(Node node) {
            super.apply(node);
            if (this.hgrow != null) {
                GenericLayoutConstraints.overrideMaxWidth(node, this);
            }
            javafx.scene.layout.HBox.setHgrow((Node)node, (Priority)(this.hgrow != null ? this.hgrow : this.hgrowReset));
            javafx.scene.layout.HBox.setMargin((Node)node, (Insets)(this.margin != null ? this.margin : this.marginReset));
        }
    }
}

