/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.nn;

import java.util.Arrays;
import org.tensorflow.GraphOperation;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.RawOp;
import org.tensorflow.op.RawOpInputs;
import org.tensorflow.op.Scope;
import org.tensorflow.op.annotation.OpInputsMetadata;
import org.tensorflow.op.annotation.OpMetadata;
import org.tensorflow.proto.DataType;
import org.tensorflow.types.family.TType;

@OpMetadata(opType="SpaceToDepth", inputsClass=Inputs.class)
public final class SpaceToDepth<T extends TType>
extends RawOp
implements Operand<T> {
    public static final String OP_NAME = "SpaceToDepth";
    private Output<T> output;

    public SpaceToDepth(Operation operation) {
        super(operation, OP_NAME);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static <T extends TType> SpaceToDepth<T> create(Scope scope, Operand<T> input, Long blockSize, Options ... options) {
        OperationBuilder opBuilder = scope.opBuilder(OP_NAME, OP_NAME);
        opBuilder.addInput(input.asOutput());
        opBuilder.setAttr("block_size", blockSize);
        if (options != null) {
            for (Options opts : options) {
                if (opts.dataFormat == null) continue;
                opBuilder.setAttr("data_format", opts.dataFormat);
            }
        }
        return new SpaceToDepth<T>(opBuilder.build());
    }

    public static Options dataFormat(String dataFormat) {
        return new Options().dataFormat(dataFormat);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    @OpInputsMetadata(outputsClass=SpaceToDepth.class)
    public static class Inputs<T extends TType>
    extends RawOpInputs<SpaceToDepth<T>> {
        public final Operand<T> input;
        public final DataType T;
        public final long blockSize;
        public final String dataFormat;

        public Inputs(GraphOperation op) {
            super(new SpaceToDepth(op), op, Arrays.asList("T", "block_size", "data_format"));
            int inputIndex = 0;
            this.input = op.input(inputIndex++);
            this.T = op.attributes().getAttrType("T");
            this.blockSize = op.attributes().getAttrInt("block_size");
            this.dataFormat = op.attributes().getAttrString("data_format");
        }
    }

    public static class Options {
        private String dataFormat;

        private Options() {
        }

        public Options dataFormat(String dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }
    }
}

