/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.tensorflow.GraphOperation;
import org.tensorflow.OperationAttributeInspector;
import org.tensorflow.op.AttributeMetadata;
import org.tensorflow.op.RawOp;
import org.tensorflow.proto.AttrValue;

public abstract class RawOpInputs<T extends RawOp> {
    private final GraphOperation op;
    private final T outputs;
    private final Set<String> attributeNames;

    public T getOutputs() {
        return this.outputs;
    }

    public Set<String> attributeNames() {
        return this.attributeNames;
    }

    public AttrValue attributeValue(String name) {
        return this.op.attributes().getAttrValueProto(name);
    }

    public Map<String, AttrValue> attributeValues() {
        LinkedHashMap<String, AttrValue> values = new LinkedHashMap<String, AttrValue>(this.attributeNames.size());
        for (String name : this.attributeNames) {
            values.put(name, this.attributeValue(name));
        }
        return values;
    }

    public AttributeMetadata attributeMetadata(String name) {
        return this.op.attributes().getAttrMetadata(name);
    }

    public OperationAttributeInspector attributes() {
        return this.op.attributes();
    }

    public final int hashCode() {
        return this.op.hashCode();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RawOpInputs)) {
            return false;
        }
        return this.op.equals(((RawOpInputs)obj).op);
    }

    public final String toString() {
        return String.format("Inputs of <%s '%s'>", this.op.type(), this.op.name());
    }

    protected RawOpInputs(T outputs, GraphOperation op, Collection<String> attributeNames) {
        this.outputs = outputs;
        this.op = op;
        this.attributeNames = Collections.unmodifiableSet(new LinkedHashSet<String>(attributeNames));
    }
}

