/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.ndarray.index;

import java.util.StringJoiner;
import org.tensorflow.ndarray.impl.dimension.Dimension;
import org.tensorflow.ndarray.index.Index;

final class Slice
implements Index {
    private final long start;
    private final long end;
    private final long stride;

    Slice(long start, long end, long stride) {
        this.start = start;
        this.end = end;
        this.stride = stride;
        if (stride == 0L) {
            throw new IllegalArgumentException("Can not have a stride of 0");
        }
    }

    @Override
    public long numElements(Dimension dim) {
        long length = this.end(dim) - this.start(dim);
        return length / this.stride + (long)(length % this.stride != 0L ? 1 : 0);
    }

    @Override
    public long mapCoordinate(long coordinate, Dimension dim) {
        return this.start(dim) + this.stride * coordinate;
    }

    @Override
    public long begin() {
        return this.start;
    }

    @Override
    public long end() {
        return this.end;
    }

    @Override
    public long stride() {
        return this.stride;
    }

    public String toString() {
        return new StringJoiner(", ", Slice.class.getSimpleName() + "(", ")").add("start=" + this.start).add("end=" + this.end).add("stride=" + this.stride).toString();
    }

    private long start(Dimension dim) {
        if (this.start < 0L) {
            return dim.numElements() + this.start;
        }
        return this.start;
    }

    private long end(Dimension dim) {
        if (this.end < 0L) {
            return dim.numElements() + this.end;
        }
        return this.end;
    }
}

