/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.internal.c_api;

import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.annotation.Properties;
import org.tensorflow.exceptions.TFFailedPreconditionException;
import org.tensorflow.exceptions.TFInvalidArgumentException;
import org.tensorflow.exceptions.TFOutOfRangeException;
import org.tensorflow.exceptions.TFPermissionDeniedException;
import org.tensorflow.exceptions.TFResourceExhaustedException;
import org.tensorflow.exceptions.TFUnauthenticatedException;
import org.tensorflow.exceptions.TFUnimplementedException;
import org.tensorflow.exceptions.TensorFlowException;
import org.tensorflow.internal.c_api.TF_Status;
import org.tensorflow.internal.c_api.presets.tensorflow;

@Properties(inherit={tensorflow.class})
public abstract class AbstractTF_Status
extends Pointer {
    public AbstractTF_Status(Pointer p) {
        super(p);
    }

    public static TF_Status newStatus() {
        TF_Status s = org.tensorflow.internal.c_api.global.tensorflow.TF_NewStatus();
        if (s != null) {
            s.deallocator(new DeleteDeallocator(s));
        }
        return s;
    }

    public void delete() {
        this.deallocate();
    }

    public void throwExceptionIfNotOK() {
        TF_Status s = (TF_Status)this;
        switch (org.tensorflow.internal.c_api.global.tensorflow.TF_GetCode(s)) {
            case 0: {
                break;
            }
            case 3: {
                throw new TFInvalidArgumentException(org.tensorflow.internal.c_api.global.tensorflow.TF_Message(s).getString());
            }
            case 16: {
                throw new TFUnauthenticatedException(org.tensorflow.internal.c_api.global.tensorflow.TF_Message(s).getString());
            }
            case 7: {
                throw new TFPermissionDeniedException(org.tensorflow.internal.c_api.global.tensorflow.TF_Message(s).getString());
            }
            case 8: {
                throw new TFResourceExhaustedException(org.tensorflow.internal.c_api.global.tensorflow.TF_Message(s).getString());
            }
            case 9: {
                throw new TFFailedPreconditionException(org.tensorflow.internal.c_api.global.tensorflow.TF_Message(s).getString());
            }
            case 11: {
                throw new TFOutOfRangeException(org.tensorflow.internal.c_api.global.tensorflow.TF_Message(s).getString());
            }
            case 12: {
                throw new TFUnimplementedException(org.tensorflow.internal.c_api.global.tensorflow.TF_Message(s).getString());
            }
            default: {
                throw new TensorFlowException(org.tensorflow.internal.c_api.global.tensorflow.TF_Message(s).getString());
            }
        }
    }

    protected static class DeleteDeallocator
    extends TF_Status
    implements Pointer.Deallocator {
        DeleteDeallocator(TF_Status s) {
            super(s);
        }

        public void deallocate() {
            if (!this.isNull()) {
                org.tensorflow.internal.c_api.global.tensorflow.TF_DeleteStatus(this);
            }
            this.setNull();
        }
    }
}

