/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.svg.util;

import java.awt.RadialGradientPaint;
import java.util.Arrays;
import org.jfree.svg.util.Args;

public class RadialGradientPaintKey {
    private final RadialGradientPaint paint;

    public RadialGradientPaintKey(RadialGradientPaint rgp) {
        Args.nullNotPermitted(rgp, "rgp");
        this.paint = rgp;
    }

    public RadialGradientPaint getPaint() {
        return this.paint;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RadialGradientPaintKey)) {
            return false;
        }
        RadialGradientPaint that = ((RadialGradientPaintKey)obj).paint;
        if (!this.paint.getCenterPoint().equals(that.getCenterPoint())) {
            return false;
        }
        if (!this.paint.getFocusPoint().equals(that.getCenterPoint())) {
            return false;
        }
        if (!Arrays.equals(this.paint.getColors(), that.getColors())) {
            return false;
        }
        return Arrays.equals(this.paint.getFractions(), that.getFractions());
    }

    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + this.paint.getCenterPoint().hashCode();
        hash = 47 * hash + this.paint.getFocusPoint().hashCode();
        hash = 47 * hash + Float.floatToIntBits(this.paint.getRadius());
        hash = 47 * hash + Arrays.hashCode(this.paint.getColors());
        hash = 47 * hash + Arrays.hashCode(this.paint.getFractions());
        return hash;
    }
}

