/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.controls.tour;

import java.util.List;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.SnapshotParameters;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TourUtils {
    private static final Logger logger = LoggerFactory.getLogger(TourUtils.class);

    public static Bounds computeScreenBounds(List<? extends Node> nodes) {
        Node firstNode = nodes.getFirst();
        Bounds bounds = firstNode.localToScreen(firstNode.getBoundsInLocal());
        if (nodes.size() > 1) {
            double minX = bounds.getMinX();
            double minY = bounds.getMinY();
            double maxX = bounds.getMaxX();
            double maxY = bounds.getMaxY();
            double minZ = bounds.getMinZ();
            double maxZ = bounds.getMaxZ();
            for (int i = 1; i < nodes.size(); ++i) {
                Node tempNode = nodes.get(i);
                Bounds tempBounds = tempNode.localToScreen(tempNode.getBoundsInLocal());
                minX = Math.min(minX, tempBounds.getMinX());
                minY = Math.min(minY, tempBounds.getMinY());
                maxX = Math.max(maxX, tempBounds.getMaxX());
                maxY = Math.max(maxY, tempBounds.getMaxY());
                minZ = Math.min(minZ, tempBounds.getMinZ());
                maxZ = Math.max(maxZ, tempBounds.getMaxZ());
            }
            bounds = new BoundingBox(minX, minY, minZ, maxX - minX, maxY - minY, maxZ - minZ);
        }
        return bounds;
    }

    public static Image createScaledSnapshot(Node node, double scale) {
        return TourUtils.createScaledSnapshot(node, null, scale);
    }

    public static Image createScaledSnapshot(Node node, Rectangle2D bounds, double scale) {
        SnapshotParameters params = new SnapshotParameters();
        params.setFill((Paint)Color.TRANSPARENT);
        if (scale != 1.0) {
            params.setTransform((Transform)new Scale(scale, scale));
        }
        if (bounds != null) {
            params.setViewport(bounds);
        }
        return node.snapshot(params, null);
    }

    public static Image createScaledSnapshot(Window window, Rectangle2D screenBounds, double scale) {
        Parent root = window.getScene().getRoot();
        Rectangle2D rect = null;
        if (screenBounds != null) {
            Bounds bounds = root.screenToLocal(TourUtils.rectToBounds(screenBounds));
            rect = new Rectangle2D(bounds.getMinX() * scale, bounds.getMinY() * scale, bounds.getWidth() * scale, bounds.getHeight() * scale);
        }
        return TourUtils.createScaledSnapshot((Node)root, rect, scale);
    }

    public static Bounds rectToBounds(Rectangle2D rect) {
        return new BoundingBox(rect.getMinX(), rect.getMinY(), rect.getWidth(), rect.getHeight());
    }

    public static Rectangle2D boundsToRect(Bounds bounds) {
        return new Rectangle2D(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
    }
}

