/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.controls.tour;

import java.util.Objects;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.stage.Window;

public class RelativeWindowMover {
    private Window currentOwner;
    private final Window window;
    private ChangeListener<Number> xListener = this::handleX;
    private ChangeListener<Number> yListener = this::handleY;

    public RelativeWindowMover(Window window) {
        Objects.requireNonNull(window);
        this.window = window;
    }

    public void attach(Window owner) {
        Objects.requireNonNull(owner);
        this.detach();
        owner.xProperty().addListener(this.xListener);
        owner.yProperty().addListener(this.yListener);
        this.currentOwner = owner;
    }

    public void detach() {
        if (this.currentOwner != null) {
            this.currentOwner.xProperty().removeListener(this.xListener);
            this.currentOwner.yProperty().removeListener(this.yListener);
        }
    }

    public Window getOwner() {
        return this.currentOwner;
    }

    public Window getWindow() {
        return this.window;
    }

    public void moveTo(double x, double y) {
        this.window.setX(x);
        this.window.setY(y);
    }

    private void handleX(ObservableValue<? extends Number> value, Number oldValue, Number newValue) {
        double deltaX = newValue.doubleValue() - oldValue.doubleValue();
        this.window.setX(this.window.getX() + deltaX);
    }

    private void handleY(ObservableValue<? extends Number> value, Number oldValue, Number newValue) {
        double deltaY = newValue.doubleValue() - oldValue.doubleValue();
        this.window.setY(this.window.getY() + deltaY);
    }
}

