/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.controls.tour;

import java.util.List;
import javafx.animation.Transition;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Duration;
import qupath.fx.controls.tour.TourHighlight;
import qupath.fx.controls.tour.TourUtils;
import qupath.fx.utils.FXUtils;

class OverlayHighlight
implements TourHighlight {
    private Stage stage;
    private Rectangle rectangle;
    private final BooleanProperty animateProperty = new SimpleBooleanProperty(true);
    private final ChangeListener<Number> windowMoveListener = this::handleStageMoved;
    private final ChangeListener<Number> windowResizeListener = this::handleStageResized;

    private void handleStageMoved(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        if (this.stage != null && this.stage.isShowing()) {
            this.hide();
        }
    }

    private void handleStageResized(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        if (this.stage != null && this.stage.isShowing()) {
            this.hide();
        }
    }

    private void attachWindowListener(Window stage) {
        stage.xProperty().addListener(this.windowMoveListener);
        stage.yProperty().addListener(this.windowMoveListener);
        stage.widthProperty().addListener(this.windowResizeListener);
        stage.heightProperty().addListener(this.windowResizeListener);
    }

    private void detachWindowListener(Window stage) {
        stage.xProperty().removeListener(this.windowMoveListener);
        stage.yProperty().removeListener(this.windowMoveListener);
        stage.widthProperty().removeListener(this.windowResizeListener);
        stage.heightProperty().removeListener(this.windowResizeListener);
    }

    @Override
    public void hide() {
        if (this.stage != null) {
            this.stage.hide();
        }
    }

    @Override
    public void show() {
        if (this.stage != null) {
            this.stage.show();
        }
    }

    public BooleanProperty animateProperty() {
        return this.animateProperty;
    }

    private boolean initialize(Window owner) {
        if (owner == null) {
            return false;
        }
        Stage stage = new Stage();
        stage.initStyle(StageStyle.TRANSPARENT);
        stage.initOwner(owner);
        this.attachWindowListener(owner);
        Rectangle rect = new Rectangle();
        rect.getStyleClass().addAll((Object[])new String[]{"tour-highlight-rect"});
        BorderPane pane = new BorderPane((Node)rect);
        pane.getStyleClass().setAll((Object[])new String[]{"tour-highlight-pane"});
        rect.setOnMouseClicked(this::handleMouseClick);
        Scene scene = new Scene((Parent)pane, (Paint)Color.TRANSPARENT);
        stage.getProperties().put((Object)"_INSTRUCTION_HIGHLIGHT", (Object)true);
        stage.setScene(scene);
        scene.getStylesheets().add((Object)OverlayHighlight.class.getClassLoader().getResource("css/tour.css").toExternalForm());
        this.rectangle = rect;
        this.stage = stage;
        return true;
    }

    private void handleMouseClick(MouseEvent event) {
        if (this.stage != null) {
            this.stage.hide();
        }
    }

    private boolean ensureInitializedForOwner(Node node) {
        Window owner;
        Window window = owner = node == null ? null : FXUtils.getWindow((Node)node);
        if (this.stage != null && this.stage.getOwner() != owner) {
            this.stage.hide();
            if (this.stage.getOwner() != null) {
                this.detachWindowListener(this.stage.getOwner());
            }
            this.stage = null;
        }
        if (this.stage == null) {
            return this.initialize(owner);
        }
        return owner != null;
    }

    @Override
    public void highlightNodes(List<? extends Node> nodes) {
        this.highlightNodes(nodes, this.animateProperty.get());
    }

    private void highlightNodes(List<? extends Node> nodes, boolean doAnimate) {
        Window lastFocusedWindow = OverlayHighlight.findFocusedWindow();
        if ((nodes = nodes.stream().filter(Node::isVisible).toList()).isEmpty()) {
            this.hide();
            return;
        }
        Node firstNode = nodes.getFirst();
        if (!firstNode.isVisible() || firstNode.getParent() != null && !firstNode.getParent().isVisible()) {
            this.hide();
            return;
        }
        if (!this.ensureInitializedForOwner(firstNode)) {
            this.hide();
            return;
        }
        Bounds bounds = TourUtils.computeScreenBounds(nodes);
        double pad = 4.0;
        double targetX = bounds.getMinX() - pad - 1.0;
        double targetY = bounds.getMinY() - pad - 1.0;
        if (!doAnimate || !this.stage.isShowing() || this.rectangle.getWidth() == 0.0 || this.rectangle.getHeight() == 0.0) {
            double newWidth = bounds.getWidth() + pad * 2.0;
            double newHeight = bounds.getHeight() + pad * 2.0;
            if (this.rectangle.getWidth() != newWidth || this.rectangle.getHeight() != newHeight) {
                this.stage.hide();
                this.rectangle.setWidth(bounds.getWidth() + pad * 2.0);
                this.rectangle.setHeight(bounds.getHeight() + pad * 2.0);
            }
            this.stage.setX(targetX);
            this.stage.setY(targetY);
        } else {
            this.rectangle.setWidth(bounds.getWidth() + 2.0 * pad);
            this.rectangle.setHeight(bounds.getHeight() + 2.0 * pad);
            this.stage.sizeToScene();
            HighlightTransition animation = new HighlightTransition(this.stage, Duration.millis((double)300.0), targetX, targetY);
            animation.playFromStart();
        }
        if (!this.stage.isShowing()) {
            this.stage.show();
            if (lastFocusedWindow != null) {
                lastFocusedWindow.requestFocus();
            }
        }
    }

    private static Window findFocusedWindow() {
        return Window.getWindows().stream().filter(Window::isFocused).findFirst().orElse(null);
    }

    private static class HighlightTransition
    extends Transition {
        private final Stage stage;
        private final double startX;
        private final double startY;
        private final double targetX;
        private final double targetY;

        private HighlightTransition(Stage stage, Duration cycleDuration, double targetX, double targetY) {
            this.stage = stage;
            this.startX = stage.getX();
            this.startY = stage.getY();
            this.targetX = targetX;
            this.targetY = targetY;
            this.setCycleDuration(cycleDuration);
        }

        protected void interpolate(double frac) {
            double newX = this.startX + frac * (this.targetX - this.startX);
            double newY = this.startY + frac * (this.targetY - this.startY);
            this.stage.setX(newX);
            this.stage.setY(newY);
        }
    }
}

