/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.controls.tour;

import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.Pagination;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.stage.Window;
import qupath.fx.controls.tour.GuiTour;
import qupath.fx.controls.tour.OverlayHighlight;
import qupath.fx.controls.tour.TourHighlight;
import qupath.fx.controls.tour.TourItem;

public class GuiTourSkin
extends SkinBase<GuiTour> {
    private final Pagination pagination;
    private final TourHighlight highlight;

    protected GuiTourSkin(GuiTour control, TourHighlight highlight) {
        super((Control)control);
        this.highlight = highlight;
        if (highlight instanceof OverlayHighlight) {
            OverlayHighlight stageHighlight = (OverlayHighlight)highlight;
            stageHighlight.animateProperty().bind((ObservableValue)control.animateProperty());
            stageHighlight.animateProperty().bind((ObservableValue)control.animateProperty());
        }
        this.pagination = this.createPagination();
        control.showHighlightProperty().addListener(this::handleShowHighlightChange);
        control.sceneProperty().flatMap(Scene::windowProperty).flatMap(Window::showingProperty).addListener(this::handleShowHighlightChange);
        this.getChildren().add((Object)this.pagination);
    }

    private void handleShowHighlightChange(ObservableValue<? extends Boolean> value, Boolean oldValue, Boolean newValue) {
        if (newValue.booleanValue()) {
            this.highlight.show();
        } else {
            this.highlight.hide();
        }
    }

    private Pagination createPagination() {
        Pagination pagination = new Pagination();
        ObservableList<TourItem> items = this.getItems();
        pagination.pageCountProperty().bind((ObservableValue)Bindings.size(items));
        pagination.setPageFactory(this::createPage);
        return pagination;
    }

    private ObservableList<TourItem> getItems() {
        return ((GuiTour)this.getSkinnable()).getItems();
    }

    private Node createPage(int pageIndex) {
        ObservableList<TourItem> items = this.getItems();
        TourItem item = (TourItem)items.get(pageIndex);
        List<Node> nodesToHighlight = item.getHighlightNodes();
        if (!nodesToHighlight.isEmpty()) {
            this.tryToEnsureVisible(nodesToHighlight.getFirst());
        }
        Node page = item.createPage();
        this.highlightNodes(nodesToHighlight);
        return page;
    }

    private void highlightNodes(List<? extends Node> nodes) {
        this.highlight.highlightNodes(nodes);
        if (!((GuiTour)this.getSkinnable()).showHighlightProperty().get()) {
            this.highlight.hide();
        }
    }

    void tryToEnsureVisible(Node node) {
        Tab tab = GuiTourSkin.searchForTab(node);
        if (tab != null) {
            tab.getTabPane().getSelectionModel().select((Object)tab);
        }
    }

    private static Tab searchForTab(Node node) {
        Parent grandparent;
        if (node == null) {
            return null;
        }
        Parent parent = grandparent = node.getParent() == null ? null : node.getParent().getParent();
        if (grandparent instanceof TabPane) {
            TabPane tabPane = (TabPane)grandparent;
            return tabPane.getTabs().stream().filter(tab -> tab.getContent() == node).findFirst().orElse(null);
        }
        return GuiTourSkin.searchForTab((Node)node.getParent());
    }
}

