/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.controls.tour;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import qupath.fx.controls.tour.CssHighlight;
import qupath.fx.controls.tour.EffectHighlight;
import qupath.fx.controls.tour.GuiTourSkin;
import qupath.fx.controls.tour.OverlayHighlight;
import qupath.fx.controls.tour.TourItem;

public class GuiTour
extends Control {
    public static final String STYLE_HIGHLIGHT_CSS = "HIGHLIGHT_CSS";
    public static final String STYLE_HIGHLIGHT_EFFECT = "HIGHLIGHT_EFFECT";
    public static final String STYLE_HIGHLIGHT_OVERLAY = "HIGHLIGHT_OVERLAY";
    private final ObservableList<TourItem> items;
    private final BooleanProperty animate = new SimpleBooleanProperty(true);
    private final BooleanProperty showHighlight = new SimpleBooleanProperty(true);

    public GuiTour() {
        this.items = FXCollections.observableArrayList();
    }

    public ObservableList<TourItem> getItems() {
        return this.items;
    }

    public BooleanProperty animateProperty() {
        return this.animate;
    }

    public void setAnimate(boolean doAnimate) {
        this.animate.set(doAnimate);
    }

    public boolean doAnimate() {
        return this.animate.get();
    }

    public BooleanProperty showHighlightProperty() {
        return this.showHighlight;
    }

    public void setShowHighlight(boolean doShow) {
        this.showHighlight.set(doShow);
    }

    public boolean doShowHighlight() {
        return this.showHighlight.get();
    }

    protected Skin<GuiTour> createDefaultSkin() {
        if (this.getStyleClass().contains((Object)STYLE_HIGHLIGHT_OVERLAY)) {
            return new GuiTourSkin(this, new OverlayHighlight());
        }
        if (this.getStyleClass().contains((Object)STYLE_HIGHLIGHT_EFFECT)) {
            return new GuiTourSkin(this, new EffectHighlight());
        }
        return new GuiTourSkin(this, new CssHighlight());
    }
}

