/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.controls.tour;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.paint.Color;
import qupath.fx.controls.tour.TourHighlight;

class EffectHighlight
implements TourHighlight {
    private final List<Node> currentNodes = new ArrayList<Node>();

    @Override
    public void show() {
        for (Node node : this.currentNodes) {
            if (node.getEffect() != null) continue;
            node.setEffect(this.createEffect(node));
        }
    }

    private Effect createEffect(Node node) {
        InnerShadow innerShadow = new InnerShadow(10.0, Color.ORANGE);
        DropShadow outerShadow = new DropShadow(10.0, Color.ORANGE);
        outerShadow.setInput((Effect)innerShadow);
        return outerShadow;
    }

    @Override
    public void hide() {
        for (Node node : this.currentNodes) {
            node.setEffect(null);
        }
    }

    @Override
    public void highlightNodes(List<? extends Node> nodes) {
        if (this.currentNodes.equals(nodes)) {
            return;
        }
        this.hide();
        this.currentNodes.clear();
        if (nodes.isEmpty()) {
            return;
        }
        nodes.stream().filter(n -> n.getEffect() == null).forEach(this.currentNodes::add);
        this.show();
    }
}

