/*
 * Decompiled with CFR 0.152.
 */
package qupath.fx.controls.tour;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.stage.Window;
import qupath.fx.controls.tour.TourHighlight;
import qupath.fx.utils.FXUtils;

class CssHighlight
implements TourHighlight {
    private static final String HIGHLIGHT_CLASS = "tour-highlight-node";
    private static final String stylesheet = CssHighlight.class.getClassLoader().getResource("css/tour.css").toExternalForm();
    private final List<Node> currentNodes = new ArrayList<Node>();

    @Override
    public void show() {
        for (Node node : this.currentNodes) {
            if (node.getStyleClass().contains((Object)HIGHLIGHT_CLASS)) continue;
            this.ensureStylesheet(FXUtils.getWindow((Node)node));
            node.getStyleClass().add((Object)HIGHLIGHT_CLASS);
        }
    }

    @Override
    public void hide() {
        for (Node node : this.currentNodes) {
            node.getStyleClass().remove((Object)HIGHLIGHT_CLASS);
        }
    }

    private boolean ensureStylesheet(Window owner) {
        if (owner == null) {
            return false;
        }
        if (!owner.getScene().getStylesheets().contains((Object)stylesheet)) {
            owner.getScene().getStylesheets().add((Object)stylesheet);
        }
        return true;
    }

    @Override
    public void highlightNodes(List<? extends Node> nodes) {
        if (this.currentNodes.equals(nodes)) {
            return;
        }
        this.hide();
        this.currentNodes.clear();
        if (nodes.isEmpty()) {
            return;
        }
        this.currentNodes.addAll(nodes);
        this.show();
    }
}

