/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.training.ui.tour;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.Map;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javax.imageio.ImageIO;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.Node;
import org.commonmark.node.Text;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.AttributeProvider;
import org.commonmark.renderer.html.HtmlRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MarkdownUtils {
    private static final Logger logger = LoggerFactory.getLogger(MarkdownUtils.class);
    private static final Parser parser = Parser.builder().build();
    private static final HtmlRenderer renderer = HtmlRenderer.builder().attributeProviderFactory(context -> new AdmonitionAttributeProvider()).build();

    MarkdownUtils() {
    }

    static String createHtml(String title, String text, Image img) {
        String imgTag;
        StringBuilder sb = new StringBuilder();
        if (title != null) {
            sb.append("### ").append(title).append("\n");
        }
        if (text != null) {
            sb.append(text).append("\n");
        }
        if (img != null && (imgTag = MarkdownUtils.createEmbeddedImage(img)) != null) {
            sb.append("\n\n").append(imgTag);
        }
        Node doc = parser.parse(sb.toString());
        String html = renderer.render(doc);
        return "<div style=\"text-align: center;\">" + html + "</div>";
    }

    private static String createEmbeddedImage(Image img) {
        Object maxDim = img.getWidth() > img.getHeight() * 2.0 && img.getHeight() > 64.0 ? "max-width: 90%;" : "max-height: " + Math.min(256.0, img.getHeight() / 2.0) + ";";
        try {
            StringBuilder sb = new StringBuilder();
            String base64 = MarkdownUtils.base64Encode(img);
            sb.append("<img src=\"data:image/png;base64,").append(base64).append("\" style=\"display: block; margin: auto; ").append((String)maxDim).append("\"").append(" />");
            return sb.toString();
        }
        catch (IOException e) {
            logger.error("Exception creating snapshot image: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private static String base64Encode(Image img) throws IOException {
        return MarkdownUtils.base64Encode(SwingFXUtils.fromFXImage((Image)img, null));
    }

    private static String base64Encode(BufferedImage img) throws IOException {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)img, "PNG", stream);
            String string = Base64.getEncoder().encodeToString(stream.toByteArray());
            return string;
        }
    }

    private static class AdmonitionAttributeProvider
    implements AttributeProvider {
        private AdmonitionAttributeProvider() {
        }

        public void setAttributes(Node node, String tagName, Map<String, String> attributes) {
            BlockQuote quote;
            String text;
            if (node instanceof BlockQuote && (text = AdmonitionAttributeProvider.findFirstText((Node)(quote = (BlockQuote)node))) != null) {
                if ((text = text.toLowerCase().strip()).startsWith("tip:")) {
                    attributes.put("class", "tip");
                } else if (text.startsWith("warning:")) {
                    attributes.put("class", "warn");
                } else if (text.startsWith("caution:")) {
                    attributes.put("class", "caution");
                } else if (text.startsWith("info:") || text.startsWith("sidenote:") || text.startsWith("note:")) {
                    attributes.put("class", "info");
                }
            }
        }

        private static String findFirstText(Node node) {
            if (node instanceof Text) {
                Text text = (Text)node;
                return text.getLiteral();
            }
            Node firstChild = node.getFirstChild();
            if (firstChild == null) {
                return null;
            }
            return AdmonitionAttributeProvider.findFirstText(firstChild);
        }
    }
}

