/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.training.ui.tour;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.web.WebView;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.ext.training.ui.tour.MarkdownUtils;
import qupath.fx.controls.tour.TourItem;
import qupath.fx.controls.tour.TourUtils;
import qupath.fx.utils.FXUtils;
import qupath.lib.gui.tools.WebViews;

public class MarkdownTourItem
implements TourItem {
    private static final Logger logger = LoggerFactory.getLogger(MarkdownTourItem.class);
    private final ResourceBundle bundle;
    private String key;
    private Supplier<Image> imageSupplier;
    private List<Node> nodes;

    private MarkdownTourItem(ResourceBundle bundle, String key, Collection<? extends Node> nodes, Supplier<Image> imageSupplier) {
        this.bundle = bundle;
        this.key = key;
        this.nodes = nodes == null ? Collections.emptyList() : List.copyOf(nodes);
        this.imageSupplier = imageSupplier;
    }

    private MarkdownTourItem(ResourceBundle bundle, String key, Collection<? extends Node> nodes) {
        this(bundle, key, nodes, null);
        this.imageSupplier = this::createScaledSnapshot;
    }

    public static TourItem create(ResourceBundle bundle, String key, Collection<? extends Node> nodes) {
        return new MarkdownTourItem(bundle, key, nodes);
    }

    public static TourItem createWithImage(ResourceBundle bundle, String key, Collection<? extends Node> nodes, Image image) {
        return MarkdownTourItem.createWithImage(bundle, key, nodes, () -> image);
    }

    public static TourItem createWithImage(ResourceBundle bundle, String key, Collection<? extends Node> nodes, Supplier<Image> imageSupplier) {
        return new MarkdownTourItem(bundle, key, nodes, imageSupplier);
    }

    @Override
    public String getTitle() {
        String titleKey = this.key + ".title";
        return this.bundle.getString(titleKey);
    }

    public String getText() {
        String textKey = this.key + ".text";
        return this.bundle.keySet().stream().filter(k -> k.startsWith(textKey)).sorted(Comparator.comparingInt(String::length)).map(this::getUpdatedString).collect(Collectors.joining("\n\n"));
    }

    private String getUpdatedString(String key) {
        String s = this.bundle.getString(key);
        if (key.contains(".text.tip")) {
            return "> **Tip:** " + s.replaceAll("\n", "\n> ");
        }
        if (key.contains(".text.info")) {
            return "> **Info:** " + s.replaceAll("\n", "\n> ");
        }
        if (key.contains(".text.caution")) {
            return "> **Caution:** " + s.replaceAll("\n", "\n> ");
        }
        return s;
    }

    public Image getImage() {
        return this.imageSupplier == null ? null : this.imageSupplier.get();
    }

    @Override
    public List<Node> getHighlightNodes() {
        return this.nodes;
    }

    @Override
    public Node createPage() {
        WebView webview = WebViews.create((boolean)true);
        String html = MarkdownUtils.createHtml(this.getTitle(), this.getText(), this.getImage());
        webview.getEngine().loadContent(html);
        return webview;
    }

    public String toString() {
        return "TourItem[" + this.getTitle() + "]";
    }

    private Image createScaledSnapshot() {
        return MarkdownTourItem.createScaledSnapshot(this.getHighlightNodes());
    }

    private static Image createScaledSnapshot(List<? extends Node> nodes) {
        if (nodes.isEmpty()) {
            return null;
        }
        Node firstNode = nodes.getFirst();
        if (nodes.size() == 1) {
            double scale = MarkdownTourItem.computeScaleFromBounds(firstNode.getLayoutBounds());
            return TourUtils.createScaledSnapshot(firstNode, scale);
        }
        Window window = FXUtils.getWindow((Node)firstNode);
        if (window != null) {
            Bounds bounds = TourUtils.computeScreenBounds(nodes);
            double scale = MarkdownTourItem.computeScaleFromBounds(bounds);
            double pad = 1.0;
            Rectangle2D rect = new Rectangle2D(bounds.getMinX() - pad, bounds.getMinY() - pad, bounds.getWidth() + pad * 2.0, bounds.getHeight() + pad * 2.0);
            return TourUtils.createScaledSnapshot(window, rect, scale);
        }
        return null;
    }

    private static double computeScaleFromBounds(Bounds bounds) {
        if (bounds == null) {
            return 1.0;
        }
        double minDim = Math.min(bounds.getWidth(), bounds.getHeight());
        if (minDim < 128.0) {
            return 2.0;
        }
        return 1.0;
    }
}

