/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.training.ui.tour;

import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Tab;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.controlsfx.control.action.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.ext.training.ui.tour.MarkdownTourItem;
import qupath.fx.controls.tour.GuiTour;
import qupath.fx.controls.tour.TourItem;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.viewer.tools.PathTools;

public class GuiTourCommand
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(GuiTourCommand.class);
    private static final ResourceBundle resources = ResourceBundle.getBundle("qupath.ext.training.ui.tour");
    private final QuPathGUI qupath;
    private GuiTour tour;
    private Stage stage;
    private String tourStyle = "HIGHLIGHT_CSS";

    public GuiTourCommand(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    private void initialize() {
        this.tour = new GuiTour();
        this.tour.getStyleClass().add((Object)this.tourStyle);
        ObservableList<TourItem> items = this.createItems(this.qupath);
        this.tour.getItems().setAll(items);
        this.stage = this.createStage();
    }

    private ObservableList<TourItem> createItems(QuPathGUI qupath) {
        return FXCollections.observableArrayList((Object[])new TourItem[]{GuiTourCommand.createItem("intro", new Node[]{qupath.getStage().getScene().getRoot()}), GuiTourCommand.createItem("tab-pane", new Node[]{qupath.getAnalysisTabPane()}), GuiTourCommand.createItem("viewer", new Node[]{qupath.getViewer().getView()}), GuiTourCommand.createItem("toolbar", new Node[]{qupath.getToolBar()}), this.createToolbarItem("toolbar.tab-pane", qupath.getCommonActions().SHOW_ANALYSIS_PANE), this.createToolbarItem("toolbar.move", qupath.getToolManager().getToolAction(PathTools.MOVE)), this.createToolbarItem("toolbar.drawing", (Action[])qupath.getToolManager().getTools().stream().filter(t -> t != PathTools.POINTS && t != PathTools.MOVE).map(p -> qupath.getToolManager().getToolAction(p)).toArray(Action[]::new)), this.createToolbarItem("toolbar.points", qupath.getToolManager().getToolAction(PathTools.POINTS)), this.createToolbarItem("toolbar.selection-mode", qupath.getToolManager().getSelectionModeAction()), this.createToolbarItem("toolbar.bc", qupath.getCommonActions().BRIGHTNESS_CONTRAST), this.createToolbarItem("toolbar.zoom-to-fit", qupath.getViewerActions().ZOOM_TO_FIT), this.createToolbarItem("toolbar.show-annotations", qupath.getOverlayActions().SHOW_ANNOTATIONS), this.createToolbarItem("toolbar.fill-annotations", qupath.getOverlayActions().FILL_ANNOTATIONS), this.createToolbarItem("toolbar.show-names", qupath.getOverlayActions().SHOW_NAMES), this.createToolbarItem("toolbar.show-tma", qupath.getOverlayActions().SHOW_TMA_GRID), this.createToolbarItem("toolbar.show-detections", qupath.getOverlayActions().SHOW_DETECTIONS), this.createToolbarItem("toolbar.fill-detections", qupath.getOverlayActions().FILL_DETECTIONS), this.createToolbarItem("toolbar.show-connections", qupath.getOverlayActions().SHOW_CONNECTIONS), this.createToolbarItem("toolbar.show-classification", qupath.getOverlayActions().SHOW_PIXEL_CLASSIFICATION), GuiTourCommand.createItem("toolbar.opacity-slider", qupath.getToolBar().lookup("#opacitySlider")), GuiTourCommand.createItem("toolbar.measurement-tables", qupath.getToolBar().lookup("#measurementTablesMenuButton")), this.createToolbarItem("toolbar.script-editor", qupath.getAutomateActions().SCRIPT_EDITOR), GuiTourCommand.createItem("toolbar.viewer-menubutton", qupath.getToolBar().lookup("#viewerMenuButton")), this.createToolbarItem("toolbar.help", qupath.getCommonActions().HELP_VIEWER), this.createToolbarItem("toolbar.log", qupath.getCommonActions().SHOW_LOG), this.createToolbarItem("toolbar.prefs", qupath.getCommonActions().PREFERENCES), this.createTabPaneItem("tab-pane.project", "Project"), this.createTabPaneItem("tab-pane.image", "Image"), this.createTabPaneItem("tab-pane.annotations", "Annotations"), this.createTabPaneItem("tab-pane.hierarchy", "Hierarchy"), this.createTabPaneItem("tab-pane.workflow", "Workflow")});
    }

    private Stage createStage() {
        Stage stage = new Stage();
        stage.initOwner((Window)this.qupath.getStage());
        stage.initModality(Modality.NONE);
        stage.setAlwaysOnTop("HIGHLIGHT_OVERLAY".equals(this.tourStyle));
        stage.setTitle(this.getTitle());
        Scene scene = new Scene((Parent)this.tour);
        stage.setScene(scene);
        return stage;
    }

    public String getTitle() {
        return resources.getString("title");
    }

    @Override
    public void run() {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater((Runnable)this);
            return;
        }
        if (this.stage == null) {
            this.initialize();
        }
        this.stage.show();
    }

    TourItem createToolbarItem(String key, Action ... actions) {
        List<Node> items = this.qupath.getToolBar().getItems().stream().filter(node -> GuiTourCommand.containsActionProperty(node, actions)).toList();
        return MarkdownTourItem.create(resources, key, items);
    }

    TourItem createTabPaneItem(String key, String tabName) {
        List<Node> items = this.qupath.getAnalysisTabPane().getTabs().stream().filter(tab -> tabName.equals(tab.getText())).map(Tab::getContent).toList();
        return MarkdownTourItem.create(resources, key, items);
    }

    private static TourItem createItem(String key, Node ... nodes) {
        return MarkdownTourItem.create(resources, key, List.of(nodes));
    }

    private static boolean containsActionProperty(Node node, Action ... actions) {
        for (Action action : actions) {
            if (!node.getProperties().containsValue((Object)action)) continue;
            return true;
        }
        return false;
    }
}

