/*
 * Decompiled with CFR 0.152.
 */
package qupath.ext.training.ui;

import java.util.ResourceBundle;
import javafx.scene.control.MenuItem;
import javafx.stage.Stage;
import org.controlsfx.control.action.Action;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.ext.training.ui.tour.GuiTourCommand;
import qupath.lib.common.Version;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.extensions.GitHubProject;
import qupath.lib.gui.extensions.QuPathExtension;
import qupath.lib.gui.tools.IconFactory;

public class TrainingExtension
implements QuPathExtension,
GitHubProject {
    private static final Logger logger = LoggerFactory.getLogger(TrainingExtension.class);
    private static final ResourceBundle resources = ResourceBundle.getBundle("qupath.ext.training.ui.strings");
    private static final String EXTENSION_NAME = resources.getString("ext.title");
    private static final String EXTENSION_DESCRIPTION = resources.getString("ext.description");
    private static final Version EXTENSION_QUPATH_VERSION = Version.parse((String)"v0.6.0");
    private static final GitHubProject.GitHubRepo EXTENSION_REPOSITORY = GitHubProject.GitHubRepo.create((String)EXTENSION_NAME, (String)"qupath", (String)"qupath-extension-training");
    private boolean isInstalled = false;
    private Stage stage;

    public void installExtension(QuPathGUI qupath) {
        if (this.isInstalled) {
            logger.debug("{} is already installed", (Object)this.getName());
            return;
        }
        this.isInstalled = true;
        GuiTourCommand tour = new GuiTourCommand(qupath);
        Action action = new Action(tour.getTitle(), e -> tour.run());
        action.setGraphic(IconFactory.createNode((FontAwesome.Glyph)FontAwesome.Glyph.MAP_MARKER));
        MenuItem item = ActionTools.createMenuItem((Action)action);
        qupath.getMenu("Help", true).getItems().addFirst((Object)item);
    }

    public String getName() {
        return EXTENSION_NAME;
    }

    public String getDescription() {
        return EXTENSION_DESCRIPTION;
    }

    public Version getQuPathVersion() {
        return EXTENSION_QUPATH_VERSION;
    }

    public GitHubProject.GitHubRepo getRepository() {
        return EXTENSION_REPOSITORY;
    }
}

