/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.richtextfx.stylers;

import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Set;
import org.fxmisc.richtext.model.StyleSpans;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.ScalarEvent;
import qupath.lib.gui.scripting.richtextfx.stylers.ScriptStyler;
import qupath.lib.gui.scripting.richtextfx.stylers.StyleSpanVisitor;

public class YamlStyler
implements ScriptStyler {
    private static final Logger logger = LoggerFactory.getLogger(YamlStyler.class);
    private static Yaml yaml = new Yaml();

    YamlStyler() {
    }

    @Override
    public Set<String> getLanguageNames() {
        return Set.of("yaml");
    }

    @Override
    public StyleSpans<Collection<String>> computeEditorStyles(String text) {
        long startTime = System.currentTimeMillis();
        StyleSpanVisitor visitor = new StyleSpanVisitor(text);
        try {
            int incValue = 0;
            for (Event event : yaml.parse((Reader)new StringReader(text))) {
                int startInd = incValue + event.getStartMark().getIndex();
                int endInd = incValue + event.getEndMark().getIndex();
                visitor.appendStyle(startInd);
                String style = null;
                switch (event.getEventId()) {
                    case Alias: {
                        break;
                    }
                    case Comment: {
                        style = "comment";
                        break;
                    }
                    case DocumentEnd: {
                        break;
                    }
                    case DocumentStart: {
                        break;
                    }
                    case MappingEnd: {
                        style = "paren";
                        break;
                    }
                    case MappingStart: {
                        style = "paren";
                        break;
                    }
                    case Scalar: {
                        style = "string";
                        if (!(event instanceof ScalarEvent)) break;
                        ScalarEvent scalar = (ScalarEvent)event;
                        String value = scalar.getValue();
                        int inc = value.length() - Character.codePointCount(value, 0, value.length());
                        if (inc > 0) {
                            endInd += inc;
                            incValue += inc;
                        }
                        if (!YamlStyler.isNumeric(value)) break;
                        style = "number";
                        break;
                    }
                    case SequenceEnd: {
                        style = "bracket";
                        break;
                    }
                    case SequenceStart: {
                        style = "bracket";
                        break;
                    }
                    case StreamEnd: {
                        break;
                    }
                    case StreamStart: {
                        break;
                    }
                }
                if (style == null) continue;
                visitor.push(style);
                visitor.appendStyle(endInd);
                visitor.pop();
            }
        }
        catch (Exception e) {
            logger.trace(e.getLocalizedMessage(), (Throwable)e);
        }
        StyleSpans<Collection<String>> styles = visitor.buildStyles();
        long endTime = System.currentTimeMillis();
        logger.trace("YAML styling time: {}", (Object)(endTime - startTime));
        return styles;
    }

    private static boolean isNumeric(String value) {
        if (value == null || value.isEmpty()) {
            return false;
        }
        try {
            Double.parseDouble(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

