/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.richtextfx.stylers;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;
import qupath.lib.gui.scripting.richtextfx.stylers.ScriptStyler;

public class XmlStyler
implements ScriptStyler {
    private static final Pattern XML_TAG = Pattern.compile("(?<ELEMENT>(</?\\h*)(\\w+)([^<>]*)(\\h*/?>))|(?<COMMENT><!--(.|\\v)+?-->)");
    private static final Pattern ATTRIBUTES = Pattern.compile("(\\w+\\h*)(=)(\\h*\"[^\"]+\")");
    private static final int GROUP_OPEN_BRACKET = 2;
    private static final int GROUP_ELEMENT_NAME = 3;
    private static final int GROUP_ATTRIBUTES_SECTION = 4;
    private static final int GROUP_CLOSE_BRACKET = 5;
    private static final int GROUP_ATTRIBUTE_NAME = 1;
    private static final int GROUP_EQUAL_SYMBOL = 2;
    private static final int GROUP_ATTRIBUTE_VALUE = 3;
    private static final Collection<String> BASE_STYLE = Collections.singletonList("xml");

    XmlStyler() {
    }

    @Override
    public Set<String> getLanguageNames() {
        return Set.of("xml");
    }

    @Override
    public StyleSpans<Collection<String>> computeEditorStyles(String text) {
        return XmlStyler.computeStyling(text);
    }

    private static StyleSpans<Collection<String>> computeStyling(String text) {
        Matcher matcher = XML_TAG.matcher(text);
        int lastKwEnd = 0;
        StyleSpansBuilder spansBuilder = new StyleSpansBuilder();
        while (matcher.find()) {
            XmlStyler.appendSpan((StyleSpansBuilder<Collection<String>>)spansBuilder, null, matcher.start() - lastKwEnd);
            if (matcher.group("COMMENT") != null) {
                XmlStyler.appendSpan((StyleSpansBuilder<Collection<String>>)spansBuilder, "comment", matcher.end() - matcher.start());
            } else if (matcher.group("ELEMENT") != null) {
                String attributesText = matcher.group(4);
                XmlStyler.appendSpan((StyleSpansBuilder<Collection<String>>)spansBuilder, "tagmark", matcher.end(2) - matcher.start(2));
                XmlStyler.appendSpan((StyleSpansBuilder<Collection<String>>)spansBuilder, "anytag", matcher.end(3) - matcher.end(2));
                if (!attributesText.isEmpty()) {
                    lastKwEnd = 0;
                    Matcher amatcher = ATTRIBUTES.matcher(attributesText);
                    while (amatcher.find()) {
                        XmlStyler.appendSpan((StyleSpansBuilder<Collection<String>>)spansBuilder, null, amatcher.start() - lastKwEnd);
                        XmlStyler.appendSpan((StyleSpansBuilder<Collection<String>>)spansBuilder, "attribute", amatcher.end(1) - amatcher.start(1));
                        XmlStyler.appendSpan((StyleSpansBuilder<Collection<String>>)spansBuilder, "tagmark", amatcher.end(2) - amatcher.end(1));
                        XmlStyler.appendSpan((StyleSpansBuilder<Collection<String>>)spansBuilder, "avalue", amatcher.end(3) - amatcher.end(2));
                        lastKwEnd = amatcher.end();
                    }
                    if (attributesText.length() > lastKwEnd) {
                        XmlStyler.appendSpan((StyleSpansBuilder<Collection<String>>)spansBuilder, null, attributesText.length() - lastKwEnd);
                    }
                }
                lastKwEnd = matcher.end(4);
                XmlStyler.appendSpan((StyleSpansBuilder<Collection<String>>)spansBuilder, "tagmark", matcher.end(5) - lastKwEnd);
            }
            lastKwEnd = matcher.end();
        }
        XmlStyler.appendSpan((StyleSpansBuilder<Collection<String>>)spansBuilder, null, text.length() - lastKwEnd);
        return spansBuilder.create();
    }

    private static void appendSpan(StyleSpansBuilder<Collection<String>> spansBuilder, String style, int length) {
        if (style == null || style.isEmpty()) {
            spansBuilder.add(BASE_STYLE, length);
        } else {
            spansBuilder.add(List.of("xml", style), length);
        }
    }
}

