/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.gui.scripting.richtextfx.stylers;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;

class StyleSpanVisitor {
    private String text;
    private StyleSpansBuilder<Collection<String>> spansBuilder = new StyleSpansBuilder();
    private int[] lineSums;
    private int lastInd;
    private Deque<String> currentStyle = new ArrayDeque<String>();

    StyleSpanVisitor(String text) {
        this.text = text;
        int[] lengths = text.lines().mapToInt(l -> l.length() + 1).toArray();
        this.lineSums = new int[lengths.length + 1];
        for (int i = 0; i < lengths.length; ++i) {
            this.lineSums[i + 1] = this.lineSums[i] + lengths[i];
        }
    }

    public void push(String style) {
        this.currentStyle.push(style);
    }

    public String pop() {
        return this.currentStyle.pop();
    }

    public StyleSpans<Collection<String>> buildStyles() {
        this.appendStyle(this.text.length(), true);
        return this.spansBuilder.create();
    }

    void appendStyle(int untilInd) {
        this.appendStyle(untilInd, false);
    }

    private void appendStyle(int untilInd, boolean lastStyle) {
        if (untilInd > this.lastInd || lastStyle) {
            if (this.currentStyle.isEmpty()) {
                this.spansBuilder.add(Collections.emptyList(), untilInd - this.lastInd);
            } else if (this.currentStyle.size() == 1) {
                this.spansBuilder.add(Collections.singletonList(this.currentStyle.peek()), untilInd - this.lastInd);
            } else {
                this.spansBuilder.add(new ArrayList<String>(this.currentStyle), untilInd - this.lastInd);
            }
        } else {
            if (untilInd <= this.lastInd) {
                return;
            }
            throw new IllegalArgumentException("Cannot append empty style from " + this.lastInd + "-" + untilInd + " (must be ascending)");
        }
        this.lastInd = untilInd;
    }
}

